/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.vfs3;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.CodeSigner;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.vfs.TempDir;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.spi.FileSystem;
import org.jboss.vfs.util.PathTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveFileSystem
implements FileSystem {
    private final Archive<?> archive;
    private final TempDir tempDirectory;
    private final File fsRoot;
    private final long creationTime = System.currentTimeMillis();

    public ArchiveFileSystem(Archive<?> archive, TempDir tempDirectory) throws IOException {
        this.archive = archive;
        this.tempDirectory = tempDirectory;
        this.fsRoot = tempDirectory.getRoot();
    }

    public void close() throws IOException {
        VFSUtils.safeClose((Closeable)this.tempDirectory);
    }

    public boolean delete(VirtualFile mountPoint, VirtualFile target) {
        boolean deleted = true;
        Node node = this.getNode(mountPoint, target);
        if (node != null) {
            File cachedFile = this.getCachedFile(node);
            if (cachedFile.exists()) {
                deleted = cachedFile.delete();
            }
            deleted = deleted && this.archive.delete(node.getPath());
        }
        return deleted;
    }

    public boolean exists(VirtualFile mountPoint, VirtualFile target) {
        return this.getNode(mountPoint, target) != null;
    }

    public CodeSigner[] getCodeSigners(VirtualFile mountPoint, VirtualFile target) {
        return null;
    }

    public List<String> getDirectoryEntries(VirtualFile mountPoint, VirtualFile target) {
        ArrayList<String> entries = new ArrayList<String>();
        Node node = this.getNode(mountPoint, target);
        if (node != null) {
            Set children = node.getChildren();
            for (Node childNode : children) {
                String path = childNode.getPath().get();
                String entryName = path.substring(path.lastIndexOf("/") + 1);
                entries.add(entryName);
            }
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFile(VirtualFile mountPoint, VirtualFile target) throws IOException {
        Node node = this.getNode(mountPoint, target);
        if (node == null) {
            return null;
        }
        File cachedFile = this.getCachedFile(node);
        if (this.fsRoot.equals(cachedFile)) {
            return this.fsRoot;
        }
        if (cachedFile.exists()) {
            return cachedFile;
        }
        Node node2 = node;
        synchronized (node2) {
            Asset asset = node.getAsset();
            cachedFile = this.buildFile(node.getPath().get());
            if (asset == null) {
                cachedFile.mkdir();
            } else {
                VFSUtils.copyStreamAndClose((InputStream)asset.openStream(), (OutputStream)new BufferedOutputStream(new FileOutputStream(cachedFile)));
            }
            return cachedFile;
        }
    }

    public long getLastModified(VirtualFile mountPoint, VirtualFile target) {
        Node node = this.getNode(mountPoint, target);
        File cachedFile = this.getCachedFile(node);
        if (cachedFile.exists()) {
            return cachedFile.lastModified();
        }
        return this.creationTime;
    }

    public long getSize(VirtualFile mountPoint, VirtualFile target) {
        Node node = this.getNode(mountPoint, target);
        File cachedFile = this.getCachedFile(node);
        if (cachedFile.exists()) {
            return cachedFile.length();
        }
        if (node.getAsset() != null) {
            try {
                return this.getFile(mountPoint, target).length();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get File", e);
            }
        }
        return 0L;
    }

    public boolean isDirectory(VirtualFile mountPoint, VirtualFile target) {
        if (this.exists(mountPoint, target)) {
            Node node = this.getNode(mountPoint, target);
            Asset asset = node.getAsset();
            return asset == null;
        }
        return false;
    }

    public boolean isFile(VirtualFile mountPoint, VirtualFile target) {
        Node node = this.getNode(mountPoint, target);
        return node != null && node.getAsset() != null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public InputStream openInputStream(VirtualFile mountPoint, VirtualFile target) throws IOException {
        InputStream stream = null;
        Node node = this.getNode(mountPoint, target);
        if (node != null) {
            File cachedFile = this.getCachedFile(node);
            if (cachedFile.exists()) {
                stream = new FileInputStream(cachedFile);
            } else if (node.getAsset() != null) {
                stream = node.getAsset().openStream();
            }
        }
        return stream;
    }

    private File getCachedFile(Node node) {
        return new File(this.fsRoot, node.getPath().get());
    }

    private Node getNode(VirtualFile mountPoint, VirtualFile target) {
        String archivePath = this.getRelativePath(mountPoint, target);
        if ("".equals(archivePath)) {
            archivePath = "/";
        }
        return this.archive.get(archivePath);
    }

    private String getRelativePath(VirtualFile mountPoint, VirtualFile target) {
        if (mountPoint.equals(target)) {
            return "";
        }
        return target.getPathNameRelativeTo(mountPoint);
    }

    private File buildFile(String path) {
        List tokens = PathTokenizer.getTokens((String)path);
        File currentFile = this.fsRoot;
        for (String token : tokens) {
            currentFile = new File(currentFile, token);
        }
        currentFile.getParentFile().mkdirs();
        return currentFile;
    }

    public File getMountSource() {
        return this.fsRoot;
    }
}

