/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.classloader;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShrinkWrapClassLoader
extends URLClassLoader
implements Closeable {
    private static final Logger log = Logger.getLogger(ShrinkWrapClassLoader.class.getName());
    private final ConcurrentMap<URL, InputStream> openedStreams = new ConcurrentHashMap<URL, InputStream>();

    public ShrinkWrapClassLoader(Archive<?> ... archives) {
        super(new URL[0]);
        if (archives == null) {
            throw new IllegalArgumentException("Archives must be specified");
        }
        this.addArchives(archives);
    }

    public ShrinkWrapClassLoader(ClassLoader parent, Archive<?> ... archives) {
        super(new URL[0], parent);
        if (archives == null) {
            throw new IllegalArgumentException("Archives must be specified");
        }
        this.addArchives(archives);
    }

    private void addArchives(Archive<?>[] archives) {
        for (Archive<?> archive : archives) {
            this.addArchive(archive);
        }
    }

    private void addArchive(final Archive<?> archive) {
        try {
            this.addURL(new URL(null, "archive:" + archive.getName() + "/", new URLStreamHandler(){

                protected URLConnection openConnection(final URL u) throws IOException {
                    return new URLConnection(u){

                        public void connect() throws IOException {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public InputStream getInputStream() throws IOException {
                            1 var1_1 = this;
                            synchronized (var1_1) {
                                InputStream input = (InputStream)ShrinkWrapClassLoader.this.openedStreams.get(u);
                                if (input == null) {
                                    ArchivePath path = this.convertToArchivePath(u);
                                    input = archive.get(path).getAsset().openStream();
                                    ShrinkWrapClassLoader.this.openedStreams.put(u, input);
                                }
                                return input;
                            }
                        }

                        private ArchivePath convertToArchivePath(URL url) {
                            String path = url.getPath();
                            path = path.replace(archive.getName(), "");
                            return ArchivePaths.create((String)path);
                        }
                    };
                }
            }));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create URL for archive: " + archive.getName(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ShrinkWrapClassLoader shrinkWrapClassLoader = this;
        synchronized (shrinkWrapClassLoader) {
            for (InputStream stream : this.openedStreams.values()) {
                try {
                    stream.close();
                }
                catch (Exception e) {
                    log.warning("Could not close opened inputstream: " + e);
                }
            }
            this.openedStreams.clear();
        }
    }
}

