/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.formatter;

import java.util.ArrayList;
import java.util.Collections;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.formatter.Formatter;

enum VerboseFormatter implements Formatter
{
    INSTANCE;


    @Override
    public String format(Archive<?> archive) throws IllegalArgumentException {
        if (archive == null) {
            throw new IllegalArgumentException("archive must be specified");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(archive.getName()).append(':').append('\n');
        ArrayList<ArchivePath> paths = new ArrayList<ArchivePath>(archive.getContent().keySet());
        Collections.sort(paths);
        int numPaths = paths.size();
        int count = 0;
        for (ArchivePath path : paths) {
            sb.append(path.get());
            if (++count == numPaths) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

