/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.plugin;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.jboss.shrinkwrap.resolver.plugin.AbstractResolverMojo;

@Mojo(name="propagate-execution-context", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class PropagateExecutionContextMojo
extends AbstractResolverMojo {
    @Parameter(property="namespace", defaultValue="maven.execution.")
    private String namespace;

    public void execute() throws MojoExecutionException {
        File globalSettings;
        MavenExecutionRequest request = this.session.getRequest();
        Properties properties = request.getUserProperties();
        File pom = this.session.getCurrentProject().getFile();
        if (pom != null) {
            this.updateUserProperty(properties, "pom-file", pom.getAbsolutePath());
        }
        this.updateUserProperty(properties, "offline", String.valueOf(this.session.isOffline()));
        File userSettings = request.getUserSettingsFile();
        if (userSettings != null) {
            this.updateUserProperty(properties, "user-settings", userSettings.getAbsolutePath());
        }
        if ((globalSettings = request.getGlobalSettingsFile()) != null) {
            this.updateUserProperty(properties, "global-settings", globalSettings.getAbsolutePath());
        }
        List profiles = this.session.getCurrentProject().getActiveProfiles();
        StringBuilder sb = new StringBuilder();
        for (Profile p : profiles) {
            sb.append(p.getId()).append(",");
        }
        if (sb.length() > 0) {
            this.updateUserProperty(properties, "active-profiles", sb.substring(0, sb.length() - 1).toString());
        }
        request.setUserProperties(properties);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    private void updateUserProperty(Properties properties, String key, String value) {
        if (key != null && value != null) {
            properties.setProperty(this.getNamespace() + key, value);
            this.getLog().debug((CharSequence)("Propagating [" + this.getNamespace() + key + "=" + value + "] from Maven Session to command line properties"));
        }
    }
}

