/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.jboss.shrinkwrap.resolver.api.maven.MavenArtifactInfo;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;

public class MavenArtifactInfoImpl
implements MavenArtifactInfo {
    private static final Logger log = Logger.getLogger(MavenArtifactInfoImpl.class.getName());
    protected final MavenCoordinate mavenCoordinate;
    protected final String resolvedVersion;
    protected final boolean snapshotVersion;
    protected final String extension;
    protected final ScopeType scopeType;
    protected final boolean optional;
    protected final MavenArtifactInfo[] dependencies;

    protected MavenArtifactInfoImpl(MavenCoordinate mavenCoordinate, String resolvedVersion, boolean snapshotVersion, String extension, ScopeType scopeType, MavenArtifactInfo[] dependencies, boolean optional) {
        this.mavenCoordinate = mavenCoordinate;
        this.resolvedVersion = resolvedVersion;
        this.snapshotVersion = snapshotVersion;
        this.extension = extension;
        this.scopeType = scopeType;
        this.dependencies = (MavenArtifactInfo[])dependencies.clone();
        this.optional = optional;
    }

    protected MavenArtifactInfoImpl(Artifact artifact, ScopeType scopeType, List<DependencyNode> children, boolean optional) {
        PackagingType packaging = PackagingType.of((String)artifact.getProperty("type", artifact.getExtension()));
        String classifier = artifact.getClassifier().isEmpty() ? packaging.getClassifier() : artifact.getClassifier();
        this.mavenCoordinate = MavenCoordinates.createCoordinate((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getBaseVersion(), (PackagingType)packaging, (String)classifier);
        this.resolvedVersion = artifact.getVersion();
        this.snapshotVersion = artifact.isSnapshot();
        this.extension = artifact.getExtension();
        this.dependencies = this.parseDependencies(children);
        this.scopeType = scopeType;
        this.optional = optional;
    }

    static MavenArtifactInfo fromDependencyNode(DependencyNode dependencyNode) {
        Artifact artifact = dependencyNode.getDependency().getArtifact();
        List children = dependencyNode.getChildren();
        ScopeType scopeType = ScopeType.RUNTIME;
        try {
            scopeType = ScopeType.fromScopeType((String)dependencyNode.getDependency().getScope());
        }
        catch (IllegalArgumentException e) {
            log.log(Level.WARNING, "Invalid scope {0} of retrieved dependency {1} will be replaced by <scope>runtime</scope>", new Object[]{dependencyNode.getDependency().getScope(), dependencyNode.getDependency().getArtifact()});
        }
        boolean optional = dependencyNode.getDependency().isOptional();
        return new MavenArtifactInfoImpl(artifact, scopeType, children, optional);
    }

    protected MavenArtifactInfo[] parseDependencies(List<DependencyNode> children) {
        MavenArtifactInfo[] dependencies = new MavenArtifactInfo[children.size()];
        int i = 0;
        for (DependencyNode child : children) {
            dependencies[i++] = MavenArtifactInfoImpl.fromDependencyNode(child);
        }
        return dependencies;
    }

    public MavenCoordinate getCoordinate() {
        return this.mavenCoordinate;
    }

    public String getResolvedVersion() {
        return this.resolvedVersion;
    }

    public boolean isSnapshotVersion() {
        return this.snapshotVersion;
    }

    public String getExtension() {
        return this.extension;
    }

    public MavenArtifactInfo[] getDependencies() {
        return this.dependencies;
    }

    public ScopeType getScope() {
        return this.scopeType;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String toString() {
        return "MavenArtifactInfoImpl [mavenCoordinate=" + this.mavenCoordinate + ", resolvedVersion=" + this.resolvedVersion + ", snapshotVersion=" + this.snapshotVersion + ", extension=" + this.extension + ", scope=" + this.scopeType + ", dependencies=" + Arrays.toString(this.dependencies) + "]";
    }
}

