/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.task;

import java.io.File;
import org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.impl.maven.task.MavenWorkingSessionTask;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureSettingsFromFileTask
implements MavenWorkingSessionTask<MavenWorkingSession> {
    private final File settingsXmlFile;

    public ConfigureSettingsFromFileTask(File settingsXmlFile) throws InvalidConfigurationFileException {
        assert (settingsXmlFile != null);
        assert (settingsXmlFile.exists());
        this.settingsXmlFile = settingsXmlFile;
    }

    public ConfigureSettingsFromFileTask(String pathToSettingsXmlFile) throws InvalidConfigurationFileException {
        assert (pathToSettingsXmlFile != null && pathToSettingsXmlFile.length() > 0);
        String resolvedPath = null;
        try {
            resolvedPath = pathToSettingsXmlFile;
            Validate.isReadable(resolvedPath, "Path to the settings.xml ('" + pathToSettingsXmlFile + "') must be defined and accessible");
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationFileException(e.getMessage());
        }
        this.settingsXmlFile = new File(resolvedPath);
    }

    @Override
    public MavenWorkingSession execute(MavenWorkingSession session) {
        try {
            Validate.isReadable(this.settingsXmlFile, "Path to the settings.xml ('" + this.settingsXmlFile + "') must be defined and accessible");
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationFileException(e.getMessage());
        }
        MavenWorkingSession newSession = session.configureSettingsFromFile(null, this.settingsXmlFile);
        return newSession.regenerateSession();
    }
}

