/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.coordinate;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.spi.MavenDependencySPI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MavenDependencyImpl
implements MavenDependencySPI {
    private final MavenCoordinate delegate;
    private final Set<MavenDependencyExclusion> exclusions;
    private final ScopeType scope;
    private final boolean optional;
    private final boolean undeclaredScope;

    public MavenDependencyImpl(MavenCoordinate coordinate, ScopeType scope, boolean optional, MavenDependencyExclusion ... exclusions) {
        this(coordinate, scope, optional, false, exclusions);
    }

    public MavenDependencyImpl(MavenCoordinate coordinate, ScopeType scope, boolean optional, boolean undeclaredScope, MavenDependencyExclusion ... exclusions) {
        assert (coordinate != null) : "coodinate is required";
        this.delegate = coordinate;
        this.scope = scope == null ? ScopeType.COMPILE : scope;
        this.optional = optional;
        this.undeclaredScope = undeclaredScope;
        HashSet<MavenDependencyExclusion> exclusionsToSet = new HashSet<MavenDependencyExclusion>(exclusions == null ? 0 : exclusions.length);
        if (exclusions != null) {
            for (MavenDependencyExclusion exclusion : exclusions) {
                if (exclusion == null) continue;
                exclusionsToSet.add(exclusion);
            }
        }
        this.exclusions = Collections.unmodifiableSet(exclusionsToSet);
    }

    public String getGroupId() {
        return this.delegate.getGroupId();
    }

    public String toCanonicalForm() {
        return this.delegate.toCanonicalForm() + ':' + this.getScope().toString();
    }

    public String getArtifactId() {
        return this.delegate.getArtifactId();
    }

    public PackagingType getPackaging() {
        return this.delegate.getPackaging();
    }

    public PackagingType getType() {
        return this.delegate.getType();
    }

    public String getClassifier() {
        return this.delegate.getClassifier();
    }

    public String getVersion() {
        return this.delegate.getVersion();
    }

    public Set<MavenDependencyExclusion> getExclusions() {
        return this.exclusions;
    }

    public ScopeType getScope() {
        return this.scope;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isUndeclaredScope() {
        return this.undeclaredScope;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenDependencyImpl other = (MavenDependencyImpl)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals((Object)other.delegate));
    }

    public String toString() {
        return MavenDependency.class.getSimpleName() + " [" + this.toCanonicalForm() + "]";
    }
}

