/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.pom;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedPomFileImpl
implements ParsedPomFile {
    private final Model model;
    private final ArtifactTypeRegistry registry;

    public ParsedPomFileImpl(Model model, ArtifactTypeRegistry registry) {
        Validate.notNull(model, "Maven Project Object Model must not be null");
        Validate.notNull(registry, "Artifact Type Registry must not be null");
        this.model = model;
        this.registry = registry;
    }

    public String getFinalName() {
        return this.model.getBuild().getFinalName() + "." + this.model.getPackaging();
    }

    public PackagingType getPackagingType() {
        return PackagingType.of((String)this.model.getPackaging());
    }

    public File getBaseDirectory() {
        return this.model.getProjectDirectory();
    }

    public File getSourceDirectory() {
        return new File(this.model.getBuild().getSourceDirectory());
    }

    public File getBuildOutputDirectory() {
        return new File(this.model.getBuild().getOutputDirectory());
    }

    public List<File> getProjectResources() {
        ArrayList<File> files = new ArrayList<File>();
        List resources = this.model.getBuild().getResources();
        for (Resource res : resources) {
            for (File candidate : FileUtils.listFiles(new File(res.getDirectory()))) {
                files.add(candidate);
            }
        }
        return files;
    }

    public File getTestSourceDirectory() {
        return new File(this.model.getBuild().getTestSourceDirectory());
    }

    public Set<MavenDependency> getDependencyManagement() {
        if (this.model.getDependencyManagement() != null) {
            Set<MavenDependency> dependencies = MavenConverter.fromDependencies(this.model.getDependencyManagement().getDependencies(), this.registry);
            return dependencies;
        }
        return Collections.emptySet();
    }

    public Set<MavenDependency> getDependencies() {
        if (this.model.getDependencies() != null) {
            return MavenConverter.fromDependencies(this.model.getDependencies(), this.registry);
        }
        return Collections.emptySet();
    }

    public Map<String, Object> getPluginConfiguration(String pluginKey) {
        Map plugins = this.model.getBuild().getPluginsAsMap();
        Plugin plugin = (Plugin)plugins.get(pluginKey);
        if (plugin == null) {
            return Collections.emptyMap();
        }
        Xpp3Dom rawConfiguration = (Xpp3Dom)plugin.getConfiguration();
        return this.toMappedConfiguration(rawConfiguration);
    }

    private Map<String, Object> toMappedConfiguration(Xpp3Dom node) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Xpp3Dom child : node.getChildren()) {
            Object value = child.getChildCount() > 0 ? this.toMappedConfiguration(child) : child.getValue();
            if (map.containsKey(child.getName())) {
                ArrayList oldValue = map.get(child.getName());
                if (!(oldValue instanceof List)) {
                    ArrayList objects = new ArrayList();
                    objects.add(oldValue);
                    oldValue = objects;
                }
                ((List)oldValue).add(value);
                value = oldValue;
            }
            map.put(child.getName(), value);
        }
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FileUtils {
        private FileUtils() {
        }

        public static Collection<File> listFiles(File root) {
            ArrayList<File> allFiles = new ArrayList<File>();
            LinkedList<File> dirs = new LinkedList<File>();
            dirs.add(root);
            while (!dirs.isEmpty()) {
                for (File f : ((File)dirs.poll()).listFiles()) {
                    if (f.isDirectory()) {
                        allFiles.add(f);
                        dirs.add(f);
                        continue;
                    }
                    if (!f.isFile()) continue;
                    allFiles.add(f);
                }
            }
            return allFiles;
        }
    }
}

