/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.Set;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.EffectivePomMavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyBuilder;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.filter.AcceptAllFilter;
import org.jboss.shrinkwrap.resolver.api.maven.filter.CombinedFilter;
import org.jboss.shrinkwrap.resolver.api.maven.filter.ScopeFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.AbstractMavenDependencyResolverBase;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyResolverImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenEnvironment;
import org.jboss.shrinkwrap.resolver.impl.maven.Validate;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;

public class EffectivePomMavenDependencyResolverImpl
extends AbstractMavenDependencyResolverBase
implements EffectivePomMavenDependencyResolver {
    public EffectivePomMavenDependencyResolverImpl(MavenEnvironment maven) {
        super(maven);
        ArtifactTypeRegistry stereotypes = maven.getArtifactTypeRegistry();
        if (maven.getModel().getDependencyManagement() != null) {
            Set<MavenDependency> pomDependencyMngmt = MavenConverter.fromDependencies(maven.getModel().getDependencyManagement().getDependencies(), stereotypes);
            maven.getVersionManagement().addAll(pomDependencyMngmt);
        }
        Set<MavenDependency> pomDefinedDependencies = MavenConverter.fromDependencies(maven.getModel().getDependencies(), stereotypes);
        maven.getVersionManagement().addAll(pomDefinedDependencies);
    }

    public MavenDependencyResolver up() {
        return new MavenDependencyResolverImpl(this.maven);
    }

    public EffectivePomMavenDependencyResolver importTestDependencies() {
        return this.importAnyDependencies((MavenResolutionFilter)new ScopeFilter(new String[]{"test"}));
    }

    public EffectivePomMavenDependencyResolver importTestDependencies(MavenResolutionFilter filter) {
        Validate.notNull(filter, "Filter must not be null");
        return this.importAnyDependencies((MavenResolutionFilter)new CombinedFilter(new MavenResolutionFilter[]{new ScopeFilter(new String[]{"test"}), filter}));
    }

    public EffectivePomMavenDependencyResolver importAllDependencies() {
        return this.importAnyDependencies((MavenResolutionFilter)AcceptAllFilter.INSTANCE);
    }

    public EffectivePomMavenDependencyResolver importAnyDependencies(MavenResolutionFilter filter) {
        Validate.notNull(filter, "Filter must not be null");
        ArtifactTypeRegistry stereotypes = this.maven.getArtifactTypeRegistry();
        Set<MavenDependency> pomDefinedDependencies = MavenConverter.fromDependencies(this.maven.getModel().getDependencies(), stereotypes);
        MavenResolutionFilter configuredFilter = filter.configure(pomDefinedDependencies);
        for (MavenDependency candidate : pomDefinedDependencies) {
            if (!configuredFilter.accept(candidate)) continue;
            this.maven.getDependencies().push(candidate);
        }
        return this;
    }

    public MavenDependencyBuilder artifact(String coordinates) throws ResolutionException {
        return (MavenDependencyBuilder)this.up().artifact(coordinates);
    }

    public MavenDependencyBuilder artifacts(String ... coordinates) throws ResolutionException {
        return (MavenDependencyBuilder)this.up().artifacts(coordinates);
    }
}

