/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.resolver.api.DependencyResolver;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.filter.AcceptAllFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenEnvironment;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenEnvironmentRetrieval;
import org.jboss.shrinkwrap.resolver.impl.maven.util.IOUtil;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyResolutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenDependencyResolverBase
implements DependencyResolver<MavenResolutionFilter, MavenDependency>,
MavenEnvironmentRetrieval {
    private static final Logger log = Logger.getLogger(AbstractMavenDependencyResolverBase.class.getName());
    private static final File[] FILE_CAST = new File[0];
    protected MavenEnvironment maven;

    protected AbstractMavenDependencyResolverBase(MavenEnvironment maven) {
        this.maven = maven;
    }

    public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(Class<ARCHIVEVIEW> archiveView) throws ResolutionException {
        return this.resolveAs(archiveView, (MavenResolutionFilter)AcceptAllFilter.INSTANCE);
    }

    public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(final Class<ARCHIVEVIEW> archiveView, MavenResolutionFilter filter) throws ResolutionException {
        Validate.notNull(archiveView, "Archive view must be specified");
        Validate.notNull(filter, "Filter must be specified");
        final ArrayList archives = new ArrayList();
        this.resolve(filter, new ArtifactMapper(){

            public void map(Artifact artifact) {
                Assignable archive = null;
                archive = "pom.xml".equals(artifact.getFile().getName()) ? ((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)(artifact.getArtifactId() + "." + artifact.getExtension()))).importDirectory(new File(artifact.getFile().getParentFile(), "target/classes")).as(archiveView) : ((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)artifact.getFile().getName())).importFrom(AbstractMavenDependencyResolverBase.this.convert(artifact.getFile())).as(archiveView);
                archives.add(archive);
            }
        });
        return archives;
    }

    public File[] resolveAsFiles() throws ResolutionException {
        return this.resolveAsFiles((MavenResolutionFilter)AcceptAllFilter.INSTANCE);
    }

    public File[] resolveAsFiles(MavenResolutionFilter filter) throws ResolutionException {
        if (filter == null) {
            throw new IllegalArgumentException("Filter must be specified");
        }
        final ArrayList files = new ArrayList();
        this.resolve(filter, new ArtifactMapper(){

            public void map(Artifact artifact) {
                if ("pom.xml".equals(artifact.getFile().getName())) {
                    String artifactId = artifact.getArtifactId();
                    String extension = artifact.getExtension();
                    File root = new File(artifact.getFile().getParentFile(), "target/classes");
                    try {
                        File archive = File.createTempFile(artifactId + "-", "." + extension);
                        archive.deleteOnExit();
                        IOUtil.packageDirectories(archive, root);
                        files.add(archive);
                    }
                    catch (IOException e) {
                        throw new ResolutionException("Unable to get artifact " + artifactId + " from the classpath", (Throwable)e);
                    }
                } else {
                    files.add(artifact.getFile());
                }
            }
        });
        return files.toArray(FILE_CAST);
    }

    private void resolve(MavenResolutionFilter filter, ArtifactMapper mapper) {
        Collection<ArtifactResult> artifacts;
        block6: {
            Validate.notEmpty(this.maven.getDependencies(), "No dependencies were set for resolution");
            CollectRequest request = new CollectRequest(MavenConverter.asDependencies(this.maven.getDependencies()), MavenConverter.asDependencies(new ArrayList<MavenDependency>(this.maven.getVersionManagement())), this.maven.getRemoteRepositories());
            filter.configure(Collections.unmodifiableList(this.maven.getDependencies()));
            artifacts = null;
            try {
                artifacts = this.maven.execute(request, filter);
            }
            catch (DependencyResolutionException e) {
                Throwable cause = e.getCause();
                if (cause == null) break block6;
                if (cause instanceof ArtifactResolutionException) {
                    throw new ResolutionException("Unable to get artifact from the repository", cause);
                }
                if (cause instanceof DependencyCollectionException) {
                    throw new ResolutionException("Unable to collect dependency tree for given dependencies", cause);
                }
                throw new ResolutionException("Unable to collect/resolve dependency tree for a resulution", (Throwable)e);
            }
        }
        for (ArtifactResult artifact : artifacts) {
            Artifact a = artifact.getArtifact();
            if ("pom".equals(a.getExtension())) {
                log.info("Removed POM artifact " + a.toString() + " from archive, it's dependencies were fetched.");
                continue;
            }
            mapper.map(a);
        }
    }

    @Override
    public MavenEnvironment getMavenEnvironment() {
        return this.maven;
    }

    private ZipFile convert(File file) throws ResolutionException {
        try {
            return new ZipFile(file);
        }
        catch (ZipException e) {
            throw new ResolutionException("Unable to treat dependency artifact \"" + file.getAbsolutePath() + "\" as a ZIP file", (Throwable)e);
        }
        catch (IOException e) {
            throw new ResolutionException("Unable to access artifact file at \"" + file.getAbsolutePath() + "\".", (Throwable)e);
        }
    }

    private static interface ArtifactMapper {
        public void map(Artifact var1);
    }
}

