/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.MarkerFileHandler;

public class BinaryDownloader {
    private final Logger log = Logger.getLogger(BinaryDownloader.class.getName());
    private final String target;
    private final MarkerFileHandler markerFileHandler;
    private final URL mavenDistribution;

    private BinaryDownloader(File mavenDir, URL mavenDistribution) {
        String distUrl = mavenDistribution.toString();
        this.mavenDistribution = mavenDistribution;
        this.target = new File(mavenDir, distUrl.substring(distUrl.lastIndexOf("/"))).getAbsolutePath();
        this.markerFileHandler = new MarkerFileHandler(mavenDir, new File(this.target).getName() + "-downloadProcess.tmp");
    }

    static File download(File mavenDir, URL mavenDistribution) {
        return new BinaryDownloader(mavenDir, mavenDistribution).download();
    }

    private File download() {
        File downloaded = this.checkIfItIsAlreadyDownloaded();
        if (downloaded == null) {
            this.markerFileHandler.createMarkerFile();
            URL redirectedMavenDistribution = this.checkForRedirect(this.mavenDistribution);
            int numberOfAttempts = 3;
            long expectedSize = this.getExpectedSize(redirectedMavenDistribution, numberOfAttempts);
            int remainingAttempts = numberOfAttempts;
            for (int i = 0; i < numberOfAttempts; ++i) {
                --remainingAttempts;
                try {
                    downloaded = this.runDownloadExecution(redirectedMavenDistribution, this.target);
                    if (downloaded != null && (downloaded.length() == expectedSize || expectedSize == -1L)) {
                        this.markerFileHandler.deleteMarkerFile();
                        return downloaded;
                    }
                    throw new IOException("An error occurred during download.");
                }
                catch (IOException e) {
                    System.err.print("ERROR: the downloading of Maven binaries has failed. ");
                    if (remainingAttempts <= 0) {
                        System.err.println("For more information see the stacktrace of an exception");
                        this.markerFileHandler.deleteMarkerFile();
                        throw new IllegalStateException(e);
                    }
                    System.err.println("Trying again - number of remaining attempts: " + remainingAttempts);
                    continue;
                }
            }
            this.markerFileHandler.deleteMarkerFile();
            throw new IllegalStateException("Unable to download Maven binaries");
        }
        return downloaded;
    }

    private File runDownloadExecution(URL mavenDistribution, String target) throws IOException {
        System.out.println("Resolver: downloading Maven binaries from " + mavenDistribution + " to " + target);
        try (ReadableByteChannel readableByteChannel = Channels.newChannel(mavenDistribution.openStream());
             FileOutputStream fileOutputStream = new FileOutputStream(target);
             FileChannel fileChannel = fileOutputStream.getChannel();){
            fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
        }
        File downloadedFile = Paths.get(target, new String[0]).toFile();
        if (downloadedFile.exists() & downloadedFile.length() > 0L) {
            return downloadedFile;
        }
        return null;
    }

    private URL checkForRedirect(URL url) {
        try {
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            int responseCode = connection.getResponseCode();
            if (responseCode > 300 && responseCode < 400) {
                String redirectLocation = connection.getHeaderField("Location");
                if (redirectLocation == null || redirectLocation.isEmpty()) {
                    throw new IllegalStateException("The site response code was a redirect one (" + responseCode + ") but no 'Location' header was sent.");
                }
                return this.checkForRedirect(new URL(redirectLocation));
            }
            return url;
        }
        catch (IOException e) {
            throw new IllegalStateException("An error occurred during redirecting of the URL", e);
        }
    }

    private long getExpectedSize(URL url, int numberOfAttempts) {
        int remainingAttempts = numberOfAttempts;
        for (int i = 0; i < numberOfAttempts; ++i) {
            --remainingAttempts;
            try {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("HEAD");
                long expectedSize = connection.getContentLengthLong();
                connection.disconnect();
                if (expectedSize == 0L) {
                    throw new IOException("Expected size of the download cannot be zero.");
                }
                return expectedSize;
            }
            catch (IOException e) {
                System.err.print("ERROR: Unable to fetch expected size. ");
                if (remainingAttempts <= 0) {
                    System.err.println("Giving up after " + numberOfAttempts + " attempts.");
                    this.markerFileHandler.deleteMarkerFile();
                    throw new IllegalStateException("Unable to determine expected size after " + numberOfAttempts + " attempts", e);
                }
                System.err.println("Retrying - number of remaining attempts: " + remainingAttempts);
                continue;
            }
        }
        return -1L;
    }

    private File checkIfItIsAlreadyDownloaded() {
        if (this.isExtractionFinished() && new File(this.target).exists()) {
            return new File(this.target);
        }
        return null;
    }

    private boolean isExtractionFinished() {
        boolean fileIsStillPresent = this.markerFileHandler.waitTillMarkerFileIsGone(60000L, "download");
        if (fileIsStillPresent) {
            try {
                Files.delete(Paths.get(this.target, new String[0]));
                this.markerFileHandler.deleteMarkerFile();
                return false;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to delete a file.", e);
            }
        }
        return true;
    }
}

