/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.embedded;

import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.BuildStage;
import org.jboss.shrinkwrap.resolver.api.maven.embedded.BuiltProject;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.BuiltProjectImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.embedded.DistributionStageImpl;

public abstract class BuildStageImpl<NEXT_STEP extends BuildStage>
extends DistributionStageImpl<NEXT_STEP>
implements BuildStage {
    private static Logger log = Logger.getLogger(BuildStageImpl.class.getName());
    private static final String SAX_PARSER_FACTORY_KEY = "javax.xml.parsers.SAXParserFactory";
    private boolean ignoreFailure = false;

    public BuiltProject build() {
        InvocationResult result;
        String oldValue;
        block7: {
            oldValue = this.removeSAXParserFactoryProperty();
            if (this.getSetMavenInstalation() != null) {
                this.getInvoker().setMavenHome(this.getSetMavenInstalation());
            }
            result = null;
            try {
                this.printStatus("started");
                result = this.getInvoker().execute(this.getInvocationRequest());
                if (result.getExitCode() == 0) break block7;
                if (this.ignoreFailure) {
                    log.severe("Maven build failed - the exit code is: " + result.getExitCode());
                    break block7;
                }
                throw new IllegalStateException("Maven build failed - the exit code is: " + result.getExitCode() + "\n To ignore this failure use method ignoreFailure()", (Throwable)result.getExecutionException());
            }
            catch (MavenInvocationException e) {
                throw new IllegalStateException("Execution of a Maven build has failed", e);
            }
            finally {
                this.printStatus("stopped");
            }
        }
        this.setSAXParserFactoryProperty(oldValue);
        return this.getBuiltProject(result);
    }

    private void printStatus(String status) {
        File pomFile = this.getInvocationRequest().getPomFile();
        String projectPom = "";
        if (pomFile == null) {
            String pomFileName;
            File baseDirectory = this.getInvocationRequest().getBaseDirectory();
            if (baseDirectory != null) {
                projectPom = baseDirectory.getName() + File.separator;
            }
            if ((pomFileName = this.getInvocationRequest().getPomFileName()) != null) {
                projectPom = projectPom + pomFileName;
            }
        } else {
            projectPom = pomFile.getParentFile().getName() + File.separator + pomFile.getName();
        }
        StringBuffer borders = new StringBuffer("==========================================");
        for (int i = 0; i < projectPom.length(); ++i) {
            borders.append("=");
        }
        System.out.println(borders.toString());
        System.out.println("===   Embedded Maven build " + status + ": " + projectPom + "   ===");
        System.out.println(borders.toString());
    }

    public BuildStage ignoreFailure(boolean ignoreFailure) {
        this.ignoreFailure = ignoreFailure;
        return this;
    }

    public BuildStage ignoreFailure() {
        this.ignoreFailure = true;
        return this;
    }

    private BuiltProject getBuiltProject(InvocationResult result) {
        File pomFile = this.getInvocationRequest().getPomFile();
        if (pomFile == null) {
            pomFile = new File(this.getInvocationRequest().getBaseDirectory() + File.separator + "pom.xml");
        }
        BuiltProjectImpl builtProject = new BuiltProjectImpl(pomFile, this.getInvocationRequest().getGlobalSettingsFile(), this.getInvocationRequest().getUserSettingsFile(), this.getInvocationRequest().getProperties(), this.profilesInArray());
        if (this.getLogBuffer() != null) {
            builtProject.setMavenLog(this.getLogBuffer().toString());
        }
        if (result != null) {
            builtProject.setMavenBuildExitCode(result.getExitCode());
        }
        return builtProject;
    }

    private String[] profilesInArray() {
        String[] profiles = new String[]{};
        List profilesList = this.getInvocationRequest().getProfiles();
        if (profilesList != null) {
            profiles = new String[profilesList.size()];
            profiles = profilesList.toArray(profiles);
        }
        return profiles;
    }

    protected abstract InvocationRequest getInvocationRequest();

    protected abstract Invoker getInvoker();

    protected abstract StringBuffer getLogBuffer();

    private String removeSAXParserFactoryProperty() {
        Object value = System.getProperties().remove(SAX_PARSER_FACTORY_KEY);
        return value != null ? (String)value : null;
    }

    private void setSAXParserFactoryProperty(String oldValue) {
        if (oldValue != null) {
            System.setProperty(SAX_PARSER_FACTORY_KEY, oldValue);
        }
    }
}

