/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.Manifest;
import org.codehaus.plexus.util.DirectoryScanner;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.api.maven.pom.Resource;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging.AbstractCompilingProcessor;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging.ArchiveFilteringUtils;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging.ManifestAsset;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins.WarPluginConfiguration;
import org.jboss.shrinkwrap.resolver.impl.maven.task.AddAllDeclaredDependenciesTask;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.jboss.shrinkwrap.resolver.spi.maven.archive.packaging.PackagingProcessor;

public class WarPackagingProcessor
extends AbstractCompilingProcessor<WebArchive>
implements PackagingProcessor<WebArchive> {
    public static final String MAVEN_WAR_PLUGIN_KEY = "org.apache.maven.plugins:maven-war-plugin";
    private WebArchive archive;

    public boolean handles(PackagingType packagingType) {
        return PackagingType.WAR.equals((Object)packagingType);
    }

    public WarPackagingProcessor configure(Archive<?> archive, MavenWorkingSession session) {
        super.configure(session);
        String archiveName = WarPackagingProcessor.hasGeneratedName(archive) ? session.getParsedPomFile().getFinalName() : archive.getName();
        this.archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)archiveName);
        return this;
    }

    public WebArchive getResultingArchive() {
        return this.archive;
    }

    public WarPackagingProcessor importBuildOutput(MavenResolutionStrategy strategy) throws IllegalArgumentException, UnsupportedOperationException {
        ParsedPomFile pomFile = this.session.getParsedPomFile();
        if (Validate.isReadable((File)pomFile.getSourceDirectory())) {
            this.compile(pomFile.getSourceDirectory(), pomFile.getBuildOutputDirectory(), ScopeType.COMPILE, ScopeType.IMPORT, ScopeType.PROVIDED, ScopeType.RUNTIME, ScopeType.SYSTEM);
            JavaArchive classes = (JavaArchive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"sources.jar")).importDirectory(pomFile.getBuildOutputDirectory()).as(JavaArchive.class);
            this.archive = (WebArchive)this.archive.merge((Archive)classes, "WEB-INF/classes");
        }
        for (Resource resource : pomFile.getResources()) {
            this.archive.addAsResource(resource.getSource(), resource.getTargetPath());
        }
        WarPluginConfiguration warConfiguration = new WarPluginConfiguration(pomFile);
        if (Validate.isReadable((File)warConfiguration.getWarSourceDirectory())) {
            WebArchive webapp = (WebArchive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"webapp.war")).importDirectory(warConfiguration.getWarSourceDirectory(), this.createFilter(warConfiguration)).as(WebArchive.class);
            this.archive = (WebArchive)this.archive.merge((Archive)webapp);
        }
        AddAllDeclaredDependenciesTask.INSTANCE.execute(this.session);
        Collection artifacts = this.session.resolveDependencies(strategy);
        for (MavenResolvedArtifact artifact : artifacts) {
            this.archive.addAsLibrary(artifact.asFile());
        }
        Manifest manifest = warConfiguration.getArchiveConfiguration().asManifest();
        this.archive.setManifest((Asset)new ManifestAsset(manifest));
        this.archive = ArchiveFilteringUtils.filterArchiveContent(this.archive, WebArchive.class, warConfiguration.getIncludes(), warConfiguration.getExcludes());
        return this;
    }

    protected Filter<ArchivePath> createFilter(WarPluginConfiguration configuration) {
        List<String> filesToIncludes = Arrays.asList(this.getFilesToIncludes(configuration.getWarSourceDirectory(), configuration.getIncludes(), configuration.getExcludes()));
        return archivePath -> {
            String stringifiedPath = archivePath.get();
            if (filesToIncludes.contains(stringifiedPath)) {
                return true;
            }
            for (String fileToInclude : filesToIncludes) {
                if (!fileToInclude.startsWith(stringifiedPath)) continue;
                return true;
            }
            return false;
        };
    }

    protected String[] getFilesToIncludes(File baseDir, String[] includes, String[] excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        if (excludes != null) {
            scanner.setExcludes(excludes);
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            includedFiles[i] = "/" + includedFiles[i].replace(File.separator, "/");
        }
        return includedFiles;
    }
}

