/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

class ConfigurationUtils {
    ConfigurationUtils() {
    }

    static String valueAsString(Map<String, Object> map, Key key, String defaultValue) {
        Validate.notNullOrEmpty((String)key.key, (String)"Key for plugin configuration must be set");
        if (map.containsKey(key.key)) {
            return map.get(key.key).toString().isEmpty() ? defaultValue : map.get(key.key).toString();
        }
        return defaultValue;
    }

    static boolean valueAsBoolean(Map<String, Object> map, Key key, boolean defaultValue) {
        return Boolean.parseBoolean(ConfigurationUtils.valueAsString(map, key, String.valueOf(defaultValue)));
    }

    static File valueAsFile(Map<String, Object> map, Key key, File basedir, File defaultValue) {
        String value = ConfigurationUtils.valueAsString(map, key, null);
        if (Validate.isNullOrEmpty((String)value)) {
            return defaultValue;
        }
        File candidate = new File(value);
        if (!candidate.isAbsolute() && basedir != null && basedir.exists()) {
            return new File(basedir, candidate.getPath());
        }
        return candidate;
    }

    static Map<String, Object> valueAsMap(Map<String, Object> map, Key key, Map<String, Object> defaultValue) {
        if (map.containsKey(key.key)) {
            Object rawOrMap = map.get(key.key);
            if (rawOrMap instanceof Map) {
                Map submap = (Map)rawOrMap;
                return submap;
            }
            return defaultValue;
        }
        return defaultValue;
    }

    static Map<String, String> valueAsMapOfStrings(Map<String, Object> map, Key key, Map<String, String> defaultValue) {
        HashMap<String, Object> castedDefaultValue = new HashMap<String, Object>(defaultValue);
        Map<String, Object> uncastedResult = ConfigurationUtils.valueAsMap(map, key, castedDefaultValue);
        HashMap<String, String> castedResult = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : uncastedResult.entrySet()) {
            castedResult.put(entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
        }
        return castedResult;
    }

    static List<String> valueAsStringList(Map<String, Object> map, Key key, List<String> defaultValue) {
        Validate.notNullOrEmpty((String)key.key, (String)"Key for plugin configuration must be set");
        if (map.containsKey(key.key)) {
            Object rawMapOrObject = map.get(key.key);
            if (key.subKey == null) {
                if (rawMapOrObject == null) {
                    return defaultValue;
                }
                return ConfigurationUtils.tokenize(rawMapOrObject, key.delimiter);
            }
            if (rawMapOrObject == null) {
                return defaultValue;
            }
            if (!(rawMapOrObject instanceof Map)) {
                return Collections.singletonList(rawMapOrObject.toString());
            }
            Map subMap = (Map)rawMapOrObject;
            Object nestedRaw = subMap.get(key.subKey);
            if (nestedRaw == null) {
                return defaultValue;
            }
            if (nestedRaw instanceof Iterable) {
                ArrayList<String> list = new ArrayList<String>();
                for (Object nested : (Iterable)nestedRaw) {
                    list.addAll(ConfigurationUtils.tokenize(nested, key.delimiter));
                }
                return list;
            }
            return ConfigurationUtils.tokenize(nestedRaw, key.delimiter);
        }
        return defaultValue;
    }

    private static List<String> tokenize(Object object, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(object.toString(), delimiter);
        while (tokenizer.hasMoreElements()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    static final class Key {
        static final String DEFAULT_DELIMITER = ",";
        final String key;
        String subKey;
        final String delimiter;

        Key(String key) {
            this.key = key;
            this.delimiter = DEFAULT_DELIMITER;
        }

        Key(String key, String subKey) {
            this.key = key;
            this.subKey = subKey;
            this.delimiter = DEFAULT_DELIMITER;
        }
    }
}

