/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.SelectorUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveFilteringUtils {
    public static <T extends Archive<?>> T filterArchiveContent(T archive, Class<T> archiveType, String[] includes, String[] excludes) {
        return ArchiveFilteringUtils.filterArchiveContent(archive, archiveType, Arrays.asList(includes), Arrays.asList(excludes));
    }

    public static <T extends Archive<?>> T filterArchiveContent(T archive, Class<T> archiveType, final List<String> includes, final List<String> excludes) {
        Map includePart = archive.getContent((Filter)new Filter<ArchivePath>(){

            public boolean include(ArchivePath path) {
                String pathAsString = path.get();
                pathAsString = pathAsString.startsWith("/") ? pathAsString.substring(1) : pathAsString;
                boolean include = false;
                block0: for (String i : includes) {
                    System.out.println("Includes: " + i + ", path: " + pathAsString);
                    if (!SelectorUtils.matchPath((String)i, (String)pathAsString, (String)"/", (boolean)true)) continue;
                    for (String e : excludes) {
                        if (!SelectorUtils.matchPath((String)e, (String)pathAsString, (String)"/", (boolean)true)) continue;
                        break block0;
                    }
                    include = true;
                    break;
                }
                return include;
            }
        });
        Archive newArchive = (Archive)ShrinkWrap.create(archiveType, (String)archive.getName());
        for (Map.Entry entry : includePart.entrySet()) {
            if (entry.getValue() == null || ((Node)entry.getValue()).getAsset() == null) continue;
            newArchive.add(((Node)entry.getValue()).getAsset(), (ArchivePath)entry.getKey());
        }
        return (T)newArchive;
    }
}

