/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.gradle;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.shrinkwrap.resolver.impl.gradle.GradleStrategyStage;
import org.jboss.shrinkwrap.resolver.impl.gradle.ScopeType;

public class ProjectEquippedResolveStage {
    private final String projectDirectory;
    private final Set<ScopeType> scopeTypeSet = new HashSet<ScopeType>();

    public ProjectEquippedResolveStage(String projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public ProjectEquippedResolveStage importDependencies(ScopeType ... scopeTypes) {
        this.scopeTypeSet.addAll(Arrays.asList(scopeTypes));
        return this;
    }

    public ProjectEquippedResolveStage importTestDependencies() {
        return this.importDependencies(ScopeType.TEST);
    }

    public ProjectEquippedResolveStage importRuntimeAndTestDependencies() {
        return this.importDependencies(ScopeType.TEST, ScopeType.RUNTIME);
    }

    public ProjectEquippedResolveStage importRuntime() {
        return this.importDependencies(ScopeType.RUNTIME);
    }

    public ProjectEquippedResolveStage importCompileAndRuntime() {
        return this.importDependencies(ScopeType.COMPILE, ScopeType.RUNTIME);
    }

    public GradleStrategyStage resolve() {
        return new GradleStrategyStage(this.projectDirectory, this.scopeTypeSet);
    }
}

