/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api.maven.coordinate;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusionImpl;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyImpl;

public final class MavenDependencies {
    private MavenDependencies() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    public static MavenDependency createDependency(String canonicalForm, ScopeType scope, boolean optional, MavenDependencyExclusion ... exclusions) throws IllegalArgumentException, CoordinateParseException {
        if (canonicalForm == null || canonicalForm.length() == 0) {
            throw new IllegalArgumentException("canonical form is required");
        }
        MavenCoordinate delegate = MavenCoordinates.createCoordinate(canonicalForm);
        return MavenDependencies.createDependency(delegate, scope, optional, exclusions);
    }

    public static MavenDependency createDependency(MavenCoordinate coordinate, ScopeType scope, boolean optional, MavenDependencyExclusion ... exclusions) throws IllegalArgumentException, CoordinateParseException {
        if (coordinate == null) {
            throw new IllegalArgumentException("coordinate form is required");
        }
        MavenDependencyImpl dep = new MavenDependencyImpl(coordinate, scope, optional, exclusions);
        return dep;
    }

    public static MavenDependencyExclusion createExclusion(String canonicalForm) throws IllegalArgumentException, CoordinateParseException {
        String artifactId;
        String groupId;
        if (canonicalForm == null || canonicalForm.length() == 0) {
            throw new IllegalArgumentException("canonical form is required");
        }
        StringTokenizer tokenizer = new StringTokenizer(canonicalForm, String.valueOf(':'));
        try {
            groupId = tokenizer.nextToken();
            artifactId = tokenizer.nextToken();
        }
        catch (NoSuchElementException nsee) {
            throw new CoordinateParseException("Canonical form must be \"groupId:artifactId\"; got: " + canonicalForm);
        }
        if (tokenizer.hasMoreTokens()) {
            throw new CoordinateParseException("Canonical form must be \"groupId:artifactId\"; got: " + canonicalForm);
        }
        MavenDependencyExclusion exclusion = MavenDependencies.createExclusion(groupId, artifactId);
        return exclusion;
    }

    public static MavenDependencyExclusion createExclusion(String groupId, String artifactId) throws IllegalArgumentException {
        if (groupId == null || groupId.length() == 0) {
            throw new IllegalArgumentException("groupId must be specified");
        }
        if (artifactId == null || artifactId.length() == 0) {
            throw new IllegalArgumentException("groupId must be specified");
        }
        MavenDependencyExclusionImpl exclusion = new MavenDependencyExclusionImpl(groupId, artifactId);
        return exclusion;
    }
}

