/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.mavenplugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.jboss.set.mavendependencyupdater.DependencyEvaluator;
import org.jboss.set.mavendependencyupdater.core.processingstrategies.TextReportProcessingStrategy;
import org.jboss.set.mavendependencyupdater.mavenplugin.AbstractUpdaterMojo;

@Mojo(name="report")
public class DependencyReportMojo
extends AbstractUpdaterMojo {
    private static final String REPORT_FILE = "dependency-upgrades-report.txt";

    @Override
    protected void processComponentUpgrades(File pomFile, List<DependencyEvaluator.ComponentUpgrade> componentUpgrades) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Writing dependency upgrades report for project " + this.project.getName()));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        TextReportProcessingStrategy strategy = new TextReportProcessingStrategy(this.configuration, pomFile, ps);
        strategy.process(componentUpgrades);
        File targetDirectory = new File(this.project.getBuild().getDirectory());
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        File reportFile = new File(targetDirectory, REPORT_FILE);
        try {
            baos.writeTo(new FileOutputStream(reportFile));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Can't write report file: " + reportFile.getPath(), (Exception)e);
        }
    }
}

