/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import org.kohsuke.github.GHDirection;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHQueryBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.PagedIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GHPullRequestQueryBuilder
extends GHQueryBuilder<GHPullRequest> {
    private final GHRepository repo;

    GHPullRequestQueryBuilder(GHRepository repo) {
        super(repo.root);
        this.repo = repo;
    }

    public GHPullRequestQueryBuilder state(GHIssueState state) {
        this.req.with("state", state);
        return this;
    }

    public GHPullRequestQueryBuilder head(String head) {
        this.req.with("head", head);
        return this;
    }

    public GHPullRequestQueryBuilder base(String base) {
        this.req.with("base", base);
        return this;
    }

    public GHPullRequestQueryBuilder sort(Sort sort) {
        this.req.with("sort", sort);
        return this;
    }

    public GHPullRequestQueryBuilder direction(GHDirection d) {
        this.req.with("direction", d);
        return this;
    }

    @Override
    public PagedIterable<GHPullRequest> list() {
        return new PagedIterable<GHPullRequest>(){

            @Override
            public PagedIterator<GHPullRequest> _iterator(int pageSize) {
                return new PagedIterator<GHPullRequest>(GHPullRequestQueryBuilder.this.req.asIterator(GHPullRequestQueryBuilder.this.repo.getApiTailUrl("pulls"), GHPullRequest[].class, pageSize)){

                    protected void wrapUp(GHPullRequest[] page) {
                        for (GHPullRequest pr : page) {
                            pr.wrapUp(GHPullRequestQueryBuilder.this.repo);
                        }
                    }
                };
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sort {
        CREATED,
        UPDATED,
        POPULARITY,
        LONG_RUNNING;

    }
}

