/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.engines;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.jboss.resteasy.client.jaxrs.engines.ApacheHttpClientEngine;
import org.jboss.resteasy.client.jaxrs.engines.HttpContextProvider;
import org.jboss.resteasy.client.jaxrs.engines.SelfExpandingBufferredInputStream;
import org.jboss.resteasy.client.jaxrs.i18n.LogMessages;
import org.jboss.resteasy.client.jaxrs.i18n.Messages;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.FinalizedClientResponse;
import org.jboss.resteasy.spi.config.ConfigurationFactory;
import org.jboss.resteasy.util.CaseInsensitiveMap;

public class ManualClosingApacheHttpClient43Engine
implements ApacheHttpClientEngine {
    private static final String processId;
    protected final HttpClient httpClient;
    protected boolean closed;
    protected final boolean allowClosingHttpClient;
    protected HttpContextProvider httpContextProvider;
    protected SSLContext sslContext;
    protected HostnameVerifier hostnameVerifier;
    protected int responseBufferSize = 8192;
    protected HttpHost defaultProxy = null;
    protected boolean chunked = false;
    protected boolean followRedirects = false;
    protected int fileUploadInMemoryThresholdLimit = 1;
    protected ApacheHttpClientEngine.MemoryUnit fileUploadMemoryUnit = ApacheHttpClientEngine.MemoryUnit.MB;
    protected File fileUploadTempFileDir = new File(ConfigurationFactory.getInstance().getConfiguration().getOptionalValue("java.io.tmpdir", String.class).orElse(null));

    public ManualClosingApacheHttpClient43Engine() {
        this.httpClient = this.createDefaultHttpClient();
        this.allowClosingHttpClient = true;
    }

    public ManualClosingApacheHttpClient43Engine(HttpHost defaultProxy) {
        this.defaultProxy = defaultProxy;
        this.httpClient = this.createDefaultHttpClient();
        this.allowClosingHttpClient = true;
    }

    public ManualClosingApacheHttpClient43Engine(HttpClient httpClient) {
        this.httpClient = httpClient;
        this.allowClosingHttpClient = true;
    }

    public ManualClosingApacheHttpClient43Engine(HttpClient httpClient, boolean closeHttpClient) {
        if (closeHttpClient && !(httpClient instanceof CloseableHttpClient)) {
            throw new IllegalArgumentException("httpClient must be a CloseableHttpClient instance in order for allowing engine to close it!");
        }
        this.httpClient = httpClient;
        this.allowClosingHttpClient = closeHttpClient;
    }

    public ManualClosingApacheHttpClient43Engine(HttpClient httpClient, HttpContextProvider httpContextProvider) {
        this.httpClient = httpClient;
        this.httpContextProvider = httpContextProvider;
        this.allowClosingHttpClient = true;
    }

    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public int getFileUploadInMemoryThresholdLimit() {
        return this.fileUploadInMemoryThresholdLimit;
    }

    public void setFileUploadInMemoryThresholdLimit(int fileUploadInMemoryThresholdLimit) {
        this.fileUploadInMemoryThresholdLimit = fileUploadInMemoryThresholdLimit;
    }

    public ApacheHttpClientEngine.MemoryUnit getFileUploadMemoryUnit() {
        return this.fileUploadMemoryUnit;
    }

    public void setFileUploadMemoryUnit(ApacheHttpClientEngine.MemoryUnit fileUploadMemoryUnit) {
        this.fileUploadMemoryUnit = fileUploadMemoryUnit;
    }

    public File getFileUploadTempFileDir() {
        return this.fileUploadTempFileDir;
    }

    public void setFileUploadTempFileDir(File fileUploadTempFileDir) {
        this.fileUploadTempFileDir = fileUploadTempFileDir;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public static CaseInsensitiveMap<String> extractHeaders(HttpResponse response) {
        CaseInsensitiveMap<String> headers = new CaseInsensitiveMap<String>();
        for (Header header : response.getAllHeaders()) {
            headers.add(header.getName(), header.getValue());
        }
        return headers;
    }

    protected InputStream createBufferedStream(InputStream is) {
        if (this.responseBufferSize == 0) {
            return is;
        }
        if (this.responseBufferSize < 0) {
            return new SelfExpandingBufferredInputStream(is);
        }
        return new BufferedInputStream(is, this.responseBufferSize);
    }

    @Override
    public Response invoke(Invocation inv) {
        HttpResponse res;
        ClientInvocation request;
        block8: {
            request = (ClientInvocation)inv;
            String uri = request.getUri().toString();
            final HttpRequestBase httpMethod = this.createHttpMethod(uri, request.getMethod());
            try {
                this.loadHttpMethod(request, httpMethod);
                if (System.getSecurityManager() == null) {
                    res = this.httpClient.execute((HttpUriRequest)httpMethod, this.httpContextProvider == null ? null : this.httpContextProvider.getContext());
                    break block8;
                }
                try {
                    res = AccessController.doPrivileged(new PrivilegedExceptionAction<HttpResponse>(){

                        @Override
                        public HttpResponse run() throws Exception {
                            return ManualClosingApacheHttpClient43Engine.this.httpClient.execute((HttpUriRequest)httpMethod, ManualClosingApacheHttpClient43Engine.this.httpContextProvider == null ? null : ManualClosingApacheHttpClient43Engine.this.httpContextProvider.getContext());
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw new RuntimeException(pae);
                }
            }
            catch (Exception e) {
                LogMessages.LOGGER.clientSendProcessingFailure(e);
                throw new ProcessingException(Messages.MESSAGES.unableToInvokeRequest(e.toString()), e);
            }
            finally {
                this.cleanUpAfterExecute(httpMethod);
            }
        }
        FinalizedClientResponse response = new FinalizedClientResponse(request.getClientConfiguration(), request.getTracingLogger()){
            InputStream stream;
            InputStream hc4Stream;

            @Override
            protected void setInputStream(InputStream is) {
                this.stream = is;
                this.resetEntity();
            }

            @Override
            public InputStream getInputStream() {
                if (this.stream == null) {
                    HttpEntity entity = res.getEntity();
                    if (entity == null) {
                        return null;
                    }
                    try {
                        this.hc4Stream = entity.getContent();
                        this.stream = ManualClosingApacheHttpClient43Engine.this.createBufferedStream(this.hc4Stream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return this.stream;
            }

            @Override
            public void releaseConnection() throws IOException {
                this.releaseConnection(true);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void releaseConnection(boolean consumeInputStream) throws IOException {
                if (consumeInputStream) {
                    try {
                        if (this.stream != null) {
                            this.stream.close();
                            return;
                        }
                        InputStream is = this.getInputStream();
                        if (is == null) return;
                        is.close();
                        return;
                    }
                    finally {
                        if (this.hc4Stream != null) {
                            try {
                                this.hc4Stream.close();
                            }
                            catch (IOException is) {}
                        } else {
                            try {
                                HttpEntity entity = res.getEntity();
                                if (entity != null) {
                                    entity.getContent().close();
                                }
                            }
                            catch (IOException entity) {}
                        }
                    }
                }
                if (!(res instanceof CloseableHttpResponse)) return;
                try {
                    ((CloseableHttpResponse)res).close();
                    return;
                }
                catch (IOException e) {
                    LogMessages.LOGGER.warn(Messages.MESSAGES.couldNotCloseHttpResponse(), e);
                }
            }
        };
        response.setProperties(request.getMutableProperties());
        response.setStatus(res.getStatusLine().getStatusCode());
        response.setReasonPhrase(res.getStatusLine().getReasonPhrase());
        response.setHeaders(ManualClosingApacheHttpClient43Engine.extractHeaders(res));
        response.setClientConfiguration(request.getClientConfiguration());
        return response;
    }

    protected HttpRequestBase createHttpMethod(String url, String restVerb) {
        if ("GET".equals(restVerb)) {
            return new HttpGet(url);
        }
        if ("POST".equals(restVerb)) {
            return new HttpPost(url);
        }
        final String verb = restVerb;
        return new HttpPost(url){

            @Override
            public String getMethod() {
                return verb;
            }
        };
    }

    protected void loadHttpMethod(ClientInvocation request, HttpRequestBase httpMethod) throws Exception {
        if (this.isFollowRedirects()) {
            this.setRedirectRequired(request, httpMethod);
        } else {
            this.setRedirectNotRequired(request, httpMethod);
        }
        if (request.getEntity() != null) {
            if (httpMethod instanceof HttpGet) {
                throw new ProcessingException(Messages.MESSAGES.getRequestCannotHaveBody());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            request.getDelegatingOutputStream().setDelegate(baos);
            try {
                HttpEntity entity = this.buildEntity(request);
                HttpPost post = (HttpPost)httpMethod;
                this.commitHeaders(request, httpMethod);
                post.setEntity(entity);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.commitHeaders(request, httpMethod);
        }
    }

    protected void commitHeaders(ClientInvocation request, HttpRequestBase httpMethod) {
        MultivaluedMap<String, String> headers = request.getHeaders().asMap();
        for (Map.Entry header : headers.entrySet()) {
            List values = (List)header.getValue();
            for (String value : values) {
                httpMethod.addHeader((String)header.getKey(), value);
            }
        }
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    @Override
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    @Override
    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    protected void cleanUpAfterExecute(HttpRequestBase httpMethod) {
        HttpPost postMethod;
        HttpEntity entity;
        if (httpMethod != null && httpMethod instanceof HttpPost && (entity = (postMethod = (HttpPost)httpMethod).getEntity()) != null && entity instanceof FileExposingFileEntity) {
            File tempRequestFile = ((FileExposingFileEntity)entity).getFile();
            try {
                boolean isDeleted = tempRequestFile.delete();
                if (!isDeleted) {
                    this.handleFileNotDeletedError(tempRequestFile, null);
                }
            }
            catch (Exception ex) {
                this.handleFileNotDeletedError(tempRequestFile, ex);
            }
        }
    }

    protected HttpEntity buildEntity(ClientInvocation request) throws IOException {
        AbstractHttpEntity entityToBuild = null;
        DeferredFileOutputStream memoryManagedOutStream = this.writeRequestBodyToOutputStream(request);
        MediaType mediaType = request.getHeaders().getMediaType();
        if (memoryManagedOutStream.isInMemory()) {
            ByteArrayEntity entityToBuildByteArray = new ByteArrayEntity(memoryManagedOutStream.getData());
            if (mediaType != null) {
                entityToBuildByteArray.setContentType(new BasicHeader("Content-Type", mediaType.toString()));
            }
            entityToBuild = entityToBuildByteArray;
        } else {
            entityToBuild = new FileExposingFileEntity(memoryManagedOutStream.getFile(), mediaType == null ? null : mediaType.toString());
        }
        if (request.isChunked()) {
            entityToBuild.setChunked(true);
        }
        return entityToBuild;
    }

    private DeferredFileOutputStream writeRequestBodyToOutputStream(ClientInvocation request) throws IOException {
        DeferredFileOutputStream memoryManagedOutStream = new DeferredFileOutputStream(this.fileUploadInMemoryThresholdLimit * this.getMemoryUnitMultiplier(), this.getTempfilePrefix(), ".tmp", this.fileUploadTempFileDir);
        request.getDelegatingOutputStream().setDelegate(memoryManagedOutStream);
        request.writeRequestBody(request.getEntityStream());
        memoryManagedOutStream.close();
        return memoryManagedOutStream;
    }

    protected String getTempfilePrefix() {
        return processId;
    }

    private int getMemoryUnitMultiplier() {
        switch (this.fileUploadMemoryUnit) {
            case BY: {
                return 1;
            }
            case KB: {
                return 1024;
            }
            case MB: {
                return 0x100000;
            }
            case GB: {
                return 0x40000000;
            }
        }
        return 1;
    }

    private void handleFileNotDeletedError(File tempRequestFile, Exception ex) {
        LogMessages.LOGGER.warn(Messages.MESSAGES.couldNotDeleteFile(tempRequestFile.getAbsolutePath()), ex);
        tempRequestFile.deleteOnExit();
    }

    protected HttpClient createDefaultHttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        RequestConfig.Builder requestBuilder = RequestConfig.custom();
        if (this.defaultProxy != null) {
            requestBuilder.setProxy(this.defaultProxy);
        }
        builder.disableContentCompression();
        builder.setDefaultRequestConfig(requestBuilder.build());
        return builder.build();
    }

    public HttpHost getDefaultProxy() {
        Configurable clientConfiguration = (Configurable)((Object)this.httpClient);
        return clientConfiguration.getConfig().getProxy();
    }

    protected void setRedirectRequired(ClientInvocation request, HttpRequestBase httpMethod) {
        RequestConfig.Builder requestBuilder = RequestConfig.copy(this.getCurrentConfiguration(request, httpMethod));
        requestBuilder.setRedirectsEnabled(true);
        httpMethod.setConfig(requestBuilder.build());
    }

    protected void setRedirectNotRequired(ClientInvocation request, HttpRequestBase httpMethod) {
        RequestConfig.Builder requestBuilder = RequestConfig.copy(this.getCurrentConfiguration(request, httpMethod));
        requestBuilder.setRedirectsEnabled(false);
        httpMethod.setConfig(requestBuilder.build());
    }

    private RequestConfig getCurrentConfiguration(ClientInvocation request, HttpRequestBase httpMethod) {
        RequestConfig baseConfig;
        if (httpMethod != null && httpMethod.getConfig() != null) {
            baseConfig = httpMethod.getConfig();
        } else {
            ManualClosingApacheHttpClient43Engine engine = (ManualClosingApacheHttpClient43Engine)request.getClient().httpEngine();
            baseConfig = ((Configurable)((Object)engine.getHttpClient())).getConfig();
            if (baseConfig == null) {
                Configurable clientConfiguration = (Configurable)((Object)this.httpClient);
                baseConfig = clientConfiguration.getConfig();
            }
        }
        return baseConfig;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.allowClosingHttpClient && this.httpClient != null) {
            try {
                ((CloseableHttpClient)this.httpClient).close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.closed = true;
    }

    static {
        try {
            processId = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return ManagementFactory.getRuntimeMXBean().getName().replaceAll("[^0-9a-zA-Z]", "");
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae);
        }
    }

    private static class FileExposingFileEntity
    extends FileEntity {
        FileExposingFileEntity(File pFile, String pContentType) {
            super(pFile, pContentType);
        }

        File getFile() {
            return this.file;
        }
    }
}

