/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import com.google.inject.Guice;
import com.google.inject.Module;
import org.eclipse.sisu.inject.BindingPublisher;
import org.eclipse.sisu.inject.InjectorBindings;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.launch.BundleModule;
import org.eclipse.sisu.launch.BundlePlan;
import org.eclipse.sisu.plexus.PlexusSpaceModule;
import org.eclipse.sisu.space.BeanScanning;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class PlexusBundlePlan
implements BundlePlan {
    private static final String SUPPORT_BUNDLE_NAME = FrameworkUtil.getBundle(PlexusSpaceModule.class).getSymbolicName();
    protected final MutableBeanLocator locator;

    public PlexusBundlePlan(MutableBeanLocator locator) {
        this.locator = locator;
    }

    @Override
    public BindingPublisher prepare(Bundle bundle2) {
        if (!SUPPORT_BUNDLE_NAME.equals(bundle2.getSymbolicName()) && (PlexusBundlePlan.hasPlexusAnnotations(bundle2) || PlexusBundlePlan.hasPlexusXml(bundle2))) {
            return new InjectorBindings(Guice.createInjector(new BundleModule(bundle2, this.locator){

                @Override
                protected Module spaceModule() {
                    return new PlexusSpaceModule(this.space, BeanScanning.select(this.getProperties()));
                }
            }));
        }
        return null;
    }

    protected static boolean hasPlexusAnnotations(Bundle bundle2) {
        String imports = (String)bundle2.getHeaders().get("Import-Package");
        return imports != null && imports.contains("org.codehaus.plexus.component.annotations");
    }

    protected static boolean hasPlexusXml(Bundle bundle2) {
        return bundle2.findEntries("META-INF/plexus", "components.xml", false) != null;
    }
}

