/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.INTERNAL.conn;

import org.apache.http.HttpResponse;
import org.apache.http.config.MessageConstraints;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.io.DefaultHttpResponseParser;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.SessionInputBuffer;
import org.commonjava.util.jhttpc.INTERNAL.conn.CloseBlockingConnectionManager;
import org.commonjava.util.jhttpc.INTERNAL.conn.SiteConnectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManagerTracker {
    private SiteConnectionConfig config;
    private CloseBlockingConnectionManager manager;
    private int users = 0;
    private boolean detached;
    private long lastRetrieval;

    public ConnectionManagerTracker(SiteConnectionConfig config) {
        this.config = config;
    }

    public synchronized CloseBlockingConnectionManager acquire() {
        if (this.manager == null) {
            Logger logger2 = LoggerFactory.getLogger(this.getClass());
            logger2.info("Creating connection pool for: {} with {} connections.", (Object)this.config.getId(), (Object)this.config.getMaxConnections());
            ManagedHttpClientConnectionFactory fac = new ManagedHttpClientConnectionFactory(new ResponseParserFactory());
            PoolingHttpClientConnectionManager poolingMgr = new PoolingHttpClientConnectionManager(this.config.getSocketFactoryRegistry(), fac);
            poolingMgr.setMaxTotal(this.config.getMaxConnections());
            this.manager = new CloseBlockingConnectionManager(this.config, poolingMgr);
        }
        ++this.users;
        return this.manager;
    }

    public synchronized void release() {
        --this.users;
        this.tryShutdown();
    }

    private void tryShutdown() {
        if (this.detached && this.users < 1) {
            Logger logger2 = LoggerFactory.getLogger(this.getClass());
            logger2.debug("Shutdown connection manager: {}", (Object)this);
            this.manager.reallyShutdown();
        }
    }

    public long getLastRetrieval() {
        return this.lastRetrieval;
    }

    public ConnectionManagerTracker retrieved() {
        this.lastRetrieval = System.currentTimeMillis();
        return this;
    }

    public void detach() {
        this.detached = true;
        this.tryShutdown();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionManagerTracker that = (ConnectionManagerTracker)o;
        return this.config.equals(that.config);
    }

    public int hashCode() {
        return this.config.hashCode();
    }

    public String toString() {
        return "ConnectionManagerTracker{config=" + this.config + ", manager=" + this.manager + ", instance=" + super.hashCode() + '}';
    }

    private class ResponseParserFactory
    implements HttpMessageParserFactory<HttpResponse> {
        private ResponseParserFactory() {
        }

        @Override
        public HttpMessageParser<HttpResponse> create(SessionInputBuffer sessionInputBuffer, MessageConstraints messageConstraints) {
            return new DefaultHttpResponseParser(sessionInputBuffer, messageConstraints);
        }
    }
}

