/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.INTERNAL.conn;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.commonjava.util.jhttpc.INTERNAL.conn.ConnectionManagerTracker;
import org.commonjava.util.jhttpc.INTERNAL.conn.SiteConnectionConfig;
import org.commonjava.util.jhttpc.JHttpCException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManagerCache {
    private static final long EXPIRATION_SECONDS = 30L;
    private static final long EXPIRATION_MILLIS = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    private final Map<SiteConnectionConfig, ConnectionManagerTracker> cache = new HashMap<SiteConnectionConfig, ConnectionManagerTracker>();
    private final Timer timer = new Timer("jhttpc-connection-manager-cache", true);

    public ConnectionManagerCache() {
        this.timer.scheduleAtFixedRate((TimerTask)new ExpirationSweeper(this), EXPIRATION_MILLIS, EXPIRATION_MILLIS);
    }

    public synchronized void expireTrackersOlderThan(long duration, TimeUnit unit) {
        long expiration = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(duration, unit);
        for (SiteConnectionConfig config : new HashSet<SiteConnectionConfig>(this.cache.keySet())) {
            ConnectionManagerTracker tracker = this.cache.get(config);
            if (tracker == null || tracker.getLastRetrieval() >= expiration) continue;
            Logger logger2 = LoggerFactory.getLogger(this.getClass());
            logger2.trace("Detaching connection tracker from cache: {}", (Object)tracker);
            this.cache.remove(config);
            tracker.detach();
        }
    }

    public synchronized ConnectionManagerTracker getTrackerFor(SiteConnectionConfig config) throws JHttpCException {
        ConnectionManagerTracker tracker = this.cache.get(config);
        if (tracker == null) {
            tracker = new ConnectionManagerTracker(config);
            this.cache.put(config, tracker);
        }
        return tracker.retrieved();
    }

    static final class ExpirationSweeper
    extends TimerTask {
        private ConnectionManagerCache cache;

        public ExpirationSweeper(ConnectionManagerCache cache) {
            this.cache = cache;
        }

        @Override
        public void run() {
            Logger logger2 = LoggerFactory.getLogger(this.getClass());
            logger2.trace("Sweeping for old connection trackers.");
            this.cache.expireTrackersOlderThan(30L, TimeUnit.SECONDS);
        }
    }
}

