/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.model.view;

import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.MavenGAView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.model.view.OriginInfo;
import org.commonjava.maven.galley.maven.model.view.ProjectVersionRefView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class MavenGAVView
extends MavenGAView
implements ProjectVersionRefView {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String rawVersion;
    private String managedVersion;
    private boolean versionLookupFinished;

    public MavenGAVView(MavenPomView pomView, Element element, OriginInfo originInfo, String managementXpathFragment) {
        super(pomView, element, originInfo, managementXpathFragment);
    }

    public MavenGAVView(MavenPomView pomView, Element element, OriginInfo originInfo) {
        this(pomView, element, originInfo, null);
    }

    @Override
    public String getVersion() throws GalleyMavenException {
        this.lookupVersion();
        return this.rawVersion == null ? this.managedVersion : this.rawVersion;
    }

    private synchronized void lookupVersion() throws GalleyMavenException {
        if (!(this.versionLookupFinished || this.rawVersion != null && this.managedVersion != null)) {
            this.versionLookupFinished = true;
            this.rawVersion = this.getValue("version");
            if (this.getManagementXpathFragment() != null) {
                this.managedVersion = this.getManagedValue("version");
            }
        }
    }

    public String getRawVersion() throws GalleyMavenException {
        this.lookupVersion();
        return this.rawVersion;
    }

    public String getManagedVersion() throws GalleyMavenException {
        if (this.getManagementXpathFragment() != null) {
            this.lookupVersion();
            return this.managedVersion;
        }
        return null;
    }

    @Override
    public ProjectVersionRef asProjectVersionRef() throws GalleyMavenException {
        try {
            return new SimpleProjectVersionRef(this.getGroupId(), this.getArtifactId(), this.getVersion());
        }
        catch (IllegalArgumentException e) {
            throw new GalleyMavenException("Cannot render ProjectVersionRef: {}:{}:{}. Reason: {}", (Throwable)e, this.getGroupId(), this.getArtifactId(), this.getVersion(), e.getMessage());
        }
    }

    protected void setVersion(String version) {
        this.setRawVersion(version);
    }

    protected void setRawVersion(String version) {
        this.rawVersion = version;
    }

    protected void setManagedVersion(String version) {
        this.managedVersion = version;
    }

    protected void setVersionLookupDone(boolean done) {
        this.versionLookupFinished = done;
    }

    @Override
    public String toString() {
        String v = this.rawVersion;
        if (v == null) {
            v = this.managedVersion;
        }
        return String.format("%s [%s:%s:%s]%s", this.getClass().getSimpleName(), this.getGroupId(), this.getArtifactId(), v == null ? "unresolved" : v, this.managedVersion == null ? "" : " (managed from: " + this.managedVersion + ")");
    }

    @Override
    public boolean isValid() {
        try {
            return super.isValid() && !this.containsExpression(this.getVersion());
        }
        catch (GalleyMavenException e) {
            this.logger.warn("Failed to lookupVersion management element. Reason: {}", (Object)e, (Object)e.getMessage());
            return false;
        }
    }
}

