/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.Properties;
import org.commonjava.maven.ext.core.state.State;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.commonjava.maven.ext.core.util.PropertyFlag;

public class PluginInjectingState
implements State {
    private static final PropertyFlag PROJECT_SOURCES_SKIP_PROPERTY = new PropertyFlag("project.src.skip", "projectSrcSkip");
    private static final PropertyFlag BMMP_SKIP_PROPERTY = new PropertyFlag("project.meta.skip", "projectMetaSkip");
    private static final PropertyFlag PROJECT_SOURCES_PLUGIN_VERSION_PROPERTY = new PropertyFlag("project.src.version", "projectSrcVersion");
    private static final String DEFAULT_PROJECT_SOURCES_PLUGIN_VERSION = "1.0";
    private static final PropertyFlag BMMP_VERSION_PROPERTY = new PropertyFlag("project.meta.version", "projectMetaVersion");
    private static final String DEFAULT_BMMP_VERSION = "1.7.0";
    private boolean projectsourcesEnabled;
    private boolean metadataEnabled;
    private String projectSrcPluginVersion;
    private String bmmpVersion;

    public PluginInjectingState(Properties userProperties) {
        this.initialise(userProperties);
    }

    @Override
    public void initialise(Properties userProperties) {
        this.projectsourcesEnabled = !Boolean.parseBoolean(PropertiesUtils.handleDeprecatedProperty(userProperties, PROJECT_SOURCES_SKIP_PROPERTY, "true"));
        this.metadataEnabled = !Boolean.parseBoolean(PropertiesUtils.handleDeprecatedProperty(userProperties, BMMP_SKIP_PROPERTY, "true"));
        this.projectSrcPluginVersion = PropertiesUtils.handleDeprecatedProperty(userProperties, PROJECT_SOURCES_PLUGIN_VERSION_PROPERTY, DEFAULT_PROJECT_SOURCES_PLUGIN_VERSION);
        this.bmmpVersion = PropertiesUtils.handleDeprecatedProperty(userProperties, BMMP_VERSION_PROPERTY, DEFAULT_BMMP_VERSION);
    }

    @Override
    public boolean isEnabled() {
        return this.isBuildMetadataPluginEnabled() || this.isProjectSourcesPluginEnabled();
    }

    public boolean isProjectSourcesPluginEnabled() {
        return this.projectsourcesEnabled;
    }

    public boolean isBuildMetadataPluginEnabled() {
        return this.metadataEnabled;
    }

    public String getProjectSourcesPluginVersion() {
        return this.projectSrcPluginVersion;
    }

    public String getBuildMetadataPluginVersion() {
        return this.bmmpVersion;
    }

    static {
        State.activeByDefault.add(PluginInjectingState.class);
    }
}

