/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.configuration;

import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.jboss.logging.Logger;
import org.jboss.set.mavendependencyupdater.VersionStream;
import org.jboss.set.mavendependencyupdater.common.ident.ScopedArtifactRef;
import org.jboss.set.mavendependencyupdater.rules.TokenizedVersion;

public class ConfigurationGenerator {
    private static final Logger LOG = Logger.getLogger(ConfigurationGenerator.class);
    private static final String ORIGINAL_VERSION_COMMENT = "Auto-generated from version ";
    private static final List<String> IGNORE_SCOPES = Arrays.asList("test");
    private static final String[] DEFAULT_QUALIFIERS = new String[]{"", "Final", "final", "Final-jbossorg-\\d+", "final-jbossorg-\\d+", "GA"};
    private static final Map<String, Object> DEFAULT_RULE = new RuleBuilder().stream(VersionStream.MICRO).qualifier(DEFAULT_QUALIFIERS).build();

    public void generateDefautlConfig(File configurationFile, Collection<ScopedArtifactRef> dependencies) throws IOException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("ignoreScopes", IGNORE_SCOPES);
        map.put("rules", this.generateRules(dependencies));
        ObjectMapper mapper = new ObjectMapper();
        ObjectWriter writer = mapper.writer(new DefaultPrettyPrinter());
        writer.writeValue(configurationFile, map);
    }

    private Map<String, Map<String, Object>> generateRules(Collection<ScopedArtifactRef> dependencies) {
        LinkedHashMap<String, Map<String, Object>> rules = new LinkedHashMap<String, Map<String, Object>>();
        rules.put("*:*", DEFAULT_RULE);
        dependencies.stream().sorted().forEach(dep -> {
            Map<String, Object> rule;
            if (!IGNORE_SCOPES.contains(dep.getScope()) && (rule = this.ruleFromVersion((ArtifactRef)dep)) != null) {
                rules.put(dep.getGroupId() + ":" + dep.getArtifactId(), rule);
            }
        });
        return rules;
    }

    private Map<String, Object> ruleFromVersion(ArtifactRef ref) {
        TokenizedVersion v = TokenizedVersion.parse(ref.getVersionString());
        String q = v.getQualifier();
        if (!StringUtils.isEmpty(q)) {
            if (q.equals("Final")) {
                return null;
            }
            if (q.equals("final")) {
                return null;
            }
            if (q.equals("GA")) {
                return null;
            }
            if (this.matches(q, "Final-jbossorg-\\d+")) {
                return this.latestWithQualifier(v, "Final-jbossorg-\\d+");
            }
            if (this.matches(q, "jbossorg-\\d+")) {
                return this.latestWithQualifier(v, "jbossorg-\\d+");
            }
            if (this.matches(q, "RC\\d+")) {
                return this.latestWithQualifier(v, "RC\\d+", "Final", "");
            }
            if (q.equals("jre")) {
                return this.latestWithQualifier(v, "jre");
            }
            if (q.startsWith("SP")) {
                return this.latestSP(v);
            }
            String milestonePattern = "A?M\\d+";
            if (this.matches(q, milestonePattern)) {
                return this.prefixAndQualifier(v, milestonePattern);
            }
            LOG.warnf("Not sure what rule to assign to this qualifier: " + ref, new Object[0]);
            return null;
        }
        return null;
    }

    private boolean matches(String str, String regex) {
        return Pattern.compile(regex).matcher(str).matches();
    }

    private Map<String, Object> latestSP(TokenizedVersion version) {
        return this.prefixAndQualifier(version, "SP\\d+");
    }

    private Map<String, Object> prefixAndQualifier(TokenizedVersion version, String qualifier) {
        int numericalSegments = version.getNumericalSegments().length;
        return new RuleBuilder().prefix(version.getPrefix(numericalSegments)).qualifier(qualifier).comment(ORIGINAL_VERSION_COMMENT + version.getVersionString()).build();
    }

    private Map<String, Object> latestWithQualifier(TokenizedVersion version, String ... qualifiers) {
        int numericalSegments = version.getNumericalSegments().length;
        return new RuleBuilder().prefix(version.getPrefix(Integer.max(2, numericalSegments - 1))).qualifier(qualifiers).comment(ORIGINAL_VERSION_COMMENT + version.getVersionString()).build();
    }

    private Map<String, Object> latest(TokenizedVersion version) {
        int numericalSegments = version.getNumericalSegments().length;
        return new RuleBuilder().prefix(version.getPrefix(Integer.max(2, numericalSegments - 1))).comment(ORIGINAL_VERSION_COMMENT + version.getVersionString()).build();
    }

    private static class RuleBuilder {
        private String prefix;
        private String stream;
        private List<String> qualifiers = new ArrayList<String>();
        private String comment;

        private RuleBuilder() {
        }

        RuleBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        RuleBuilder qualifier(String ... regexprs) {
            this.qualifiers.addAll(Arrays.asList(regexprs));
            return this;
        }

        RuleBuilder stream(VersionStream stream) {
            this.stream = stream.name();
            return this;
        }

        RuleBuilder comment(String comment) {
            this.comment = comment;
            return this;
        }

        Map<String, Object> build() {
            HashMap<String, Object> rule = new HashMap<String, Object>();
            if (this.prefix != null) {
                rule.put("PREFIX", this.prefix);
            }
            if (this.stream != null) {
                rule.put("STREAM", this.stream);
            }
            if (this.qualifiers.size() == 1) {
                rule.put("QUALIFIER", this.qualifiers.get(0));
            } else if (this.qualifiers.size() > 1) {
                rule.put("QUALIFIER", this.qualifiers);
            }
            if (this.comment != null) {
                rule.put("COMMENT", this.comment);
            }
            return rule;
        }
    }
}

