/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater.cli;

import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jboss.logging.Logger;
import org.jboss.set.mavendependencyupdater.DefaultAvailableVersionsResolver;
import org.jboss.set.mavendependencyupdater.DependencyEvaluator;
import org.jboss.set.mavendependencyupdater.common.ident.ScopedArtifactRef;
import org.jboss.set.mavendependencyupdater.configuration.Configuration;
import org.jboss.set.mavendependencyupdater.configuration.ConfigurationGenerator;
import org.jboss.set.mavendependencyupdater.core.processingstrategies.HtmlReportProcessingStrategy;
import org.jboss.set.mavendependencyupdater.core.processingstrategies.ModifyLocallyProcessingStrategy;
import org.jboss.set.mavendependencyupdater.core.processingstrategies.SeparatePRsProcessingStrategy;
import org.jboss.set.mavendependencyupdater.core.processingstrategies.TextReportProcessingStrategy;
import org.jboss.set.mavendependencyupdater.core.processingstrategies.UpgradeProcessingStrategy;
import org.jboss.set.mavendependencyupdater.projectparser.PmeDependencyCollector;

public class Cli {
    private static final Logger LOG = Logger.getLogger(Cli.class);
    private static final String PERFORM_UPGRADES = "perform-upgrades";
    private static final String GENERATE_PRS = "generate-prs";
    private static final String GENERATE_REPORT = "generate-report";
    private static final String GENERATE_HTML_REPORT = "generate-html-report";
    private static final String GENERATE_CONFIG = "generate-config";
    private static final String CHECK_CONFIG = "check-config";
    private static final String[] COMMANDS = new String[]{"perform-upgrades", "generate-prs", "generate-report", "generate-html-report", "generate-config", "check-config"};
    private static final String PREFIX_DOESNT_MATCH_MSG = "Dependency %s doesn't match prefix '%s'";
    private Options options;
    private CommandLineParser parser = new DefaultParser();
    private Configuration configuration;
    private Collection<ScopedArtifactRef> rootProjectDependencies;

    public static void main(String[] args) {
        try {
            System.exit(new Cli().run(args));
        }
        catch (Exception e) {
            LOG.error(e);
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private Cli() {
        this.options = new Options();
        this.options.addOption(Option.builder("h").longOpt("help").desc("Print help").build());
        this.options.addOption(Option.builder("c").longOpt("config").hasArgs().numberOfArgs(1).desc("Configuration JSON file").build());
        this.options.addOption(Option.builder("f").longOpt("file").hasArgs().numberOfArgs(1).desc("POM file").build());
        this.options.addOption(Option.builder("o").longOpt("output").hasArgs().numberOfArgs(1).desc("output file for report generation").build());
    }

    private int run(String[] args) throws Exception {
        boolean success;
        CommandLine cmd;
        try {
            cmd = this.parser.parse(this.options, args);
        }
        catch (ParseException e) {
            LOG.debug((Object)"Caught problem parsing CLI arguments", e);
            System.err.println(e.getMessage());
            this.printHelp();
            return 10;
        }
        if (cmd.hasOption('h')) {
            this.printHelp();
            return 0;
        }
        String[] arguments = cmd.getArgs();
        if (arguments.length != 1) {
            System.err.println("Single action argument expected.");
            this.printHelp();
            return 10;
        }
        if (!ArrayUtils.contains(COMMANDS, arguments[0])) {
            System.err.println("Unknown command: " + arguments[0]);
            this.printHelp();
            return 10;
        }
        File configurationFile = null;
        if (cmd.hasOption('c')) {
            configurationFile = new File(cmd.getOptionValue('c'));
        }
        if (!cmd.hasOption('f')) {
            System.err.println("Missing option 'f'");
            this.printHelp();
            return 10;
        }
        File pomFile = new File(cmd.getOptionValue('f'));
        this.rootProjectDependencies = new PmeDependencyCollector(pomFile).getRootProjectDependencies();
        if (PERFORM_UPGRADES.equals(arguments[0])) {
            this.configuration = new Configuration(configurationFile);
            success = this.performAlignment(new ModifyLocallyProcessingStrategy(pomFile));
        } else if (GENERATE_PRS.equals(arguments[0])) {
            this.configuration = new Configuration(configurationFile);
            SeparatePRsProcessingStrategy strategy = new SeparatePRsProcessingStrategy(this.configuration, pomFile);
            success = this.performAlignment(strategy);
        } else if (GENERATE_REPORT.equals(arguments[0])) {
            this.configuration = new Configuration(configurationFile);
            TextReportProcessingStrategy strategy = cmd.hasOption('o') ? new TextReportProcessingStrategy(this.configuration, pomFile, cmd.getOptionValue('o')) : new TextReportProcessingStrategy(this.configuration, pomFile, System.out);
            success = this.performAlignment(strategy);
        } else if (GENERATE_HTML_REPORT.equals(arguments[0])) {
            this.configuration = new Configuration(configurationFile);
            HtmlReportProcessingStrategy strategy = cmd.hasOption('o') ? new HtmlReportProcessingStrategy(this.configuration, pomFile, cmd.getOptionValue('o')) : new HtmlReportProcessingStrategy(this.configuration, pomFile, System.out);
            success = this.performAlignment(strategy);
        } else if (GENERATE_CONFIG.equals(arguments[0])) {
            new ConfigurationGenerator().generateDefautlConfig(configurationFile, this.rootProjectDependencies);
            success = true;
        } else if (CHECK_CONFIG.equals(arguments[0])) {
            this.configuration = new Configuration(configurationFile);
            Collection<Pair<ScopedArtifactRef, String>> outOfDate = this.configuration.findOutOfDateRestrictions(this.rootProjectDependencies);
            outOfDate.forEach(p -> System.err.println(String.format(PREFIX_DOESNT_MATCH_MSG, p.getLeft(), p.getRight())));
            success = true;
        } else {
            System.err.println("Unknown action: " + arguments[0]);
            this.printHelp();
            return 10;
        }
        if (success) {
            return 0;
        }
        return 11;
    }

    private void printHelp() {
        String header = "\nCommands:\n  generate-report    Generates text report\n  perform-upgrades   Locally perform dependencies in given POM file\n  generate-prs       Aligns dependencies in given POM file and generates\n                     separate pull requests for each upgrade\n  generate-config    Generates somewhat sane base for dependency alignment\n                     configuration for given project\n  check-config       Checks if configuration is up-to-date\n                     (project dependencies match configured version\n                     prefixes)\n\nParameters:\n";
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar <path/to/cli.jar> <command> <params>", header, this.options, "");
    }

    private boolean performAlignment(UpgradeProcessingStrategy strategy) {
        assert (this.configuration != null);
        assert (this.rootProjectDependencies != null);
        DefaultAvailableVersionsResolver availableVersionsResolver = new DefaultAvailableVersionsResolver(this.configuration);
        DependencyEvaluator evaluator = new DependencyEvaluator(this.configuration, availableVersionsResolver);
        List<DependencyEvaluator.ComponentUpgrade> componentUpgrades = evaluator.getVersionsToUpgrade(this.rootProjectDependencies);
        return strategy.process(componentUpgrades);
    }
}

