/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.internal.version;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.util.JoinString;
import org.commonjava.maven.atlas.ident.util.VersionUtils;
import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;
import org.commonjava.maven.atlas.ident.version.SingleVersion;
import org.commonjava.maven.atlas.ident.version.VersionSpec;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.ProjectVersionRefLocation;
import org.commonjava.maven.galley.maven.model.view.meta.MavenMetadataView;
import org.commonjava.maven.galley.maven.parse.MavenMetadataReader;
import org.commonjava.maven.galley.maven.spi.version.VersionResolver;
import org.commonjava.maven.galley.maven.version.VersionSelectionStrategy;
import org.commonjava.maven.galley.model.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class VersionResolverImpl
implements VersionResolver {
    private static final String SNAP_VERSION_XPATH = "/metadata/versioning/snapshotVersions/snapshotVersion[1]/value";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private MavenMetadataReader metadataReader;

    protected VersionResolverImpl() {
    }

    public VersionResolverImpl(MavenMetadataReader metadataReader) {
        this.metadataReader = metadataReader;
    }

    @Override
    public ProjectVersionRef resolveLatestVariableVersion(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy) throws TransferException {
        return this.resolveLatestVariableVersion(locations, ref, selectionStrategy, new EventMetadata());
    }

    @Override
    public ProjectVersionRef resolveLatestVariableVersion(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        if (!ref.getVersionSpec().isSingle()) {
            return this.resolveLatestMultiRef(locations, ref, selectionStrategy, eventMetadata);
        }
        if (ref.isSnapshot()) {
            return this.resolveLatestSnapshotRef(locations, ref, selectionStrategy, eventMetadata);
        }
        return ref;
    }

    @Override
    public ProjectVersionRef resolveFirstMatchVariableVersion(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy) throws TransferException {
        return this.resolveFirstMatchVariableVersion(locations, ref, selectionStrategy, new EventMetadata());
    }

    @Override
    public ProjectVersionRef resolveFirstMatchVariableVersion(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        if (!ref.getVersionSpec().isSingle()) {
            return this.resolveFirstMultiRef(locations, ref, selectionStrategy, eventMetadata);
        }
        if (ref.isSnapshot()) {
            return this.resolveFirstSnapshotRef(locations, ref, selectionStrategy, eventMetadata);
        }
        return ref;
    }

    @Override
    public ProjectVersionRefLocation resolveLatestVariableVersionLocation(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy) throws TransferException {
        return this.resolveLatestVariableVersionLocation(locations, ref, selectionStrategy, new EventMetadata());
    }

    @Override
    public ProjectVersionRefLocation resolveLatestVariableVersionLocation(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        if (!ref.getVersionSpec().isSingle()) {
            return this.resolveLatestMultiRefWithLocation(locations, ref, selectionStrategy, eventMetadata);
        }
        if (ref.isSnapshot()) {
            return this.resolveLatestSnapshotRefWithLocation(locations, ref, selectionStrategy, eventMetadata);
        }
        return null;
    }

    @Override
    public ProjectVersionRefLocation resolveFirstMatchVariableVersionLocation(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy) throws TransferException {
        return this.resolveFirstMatchVariableVersionLocation(locations, ref, selectionStrategy, new EventMetadata());
    }

    @Override
    public ProjectVersionRefLocation resolveFirstMatchVariableVersionLocation(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        if (!ref.getVersionSpec().isSingle()) {
            return this.resolveFirstMultiRefWithLocation(locations, ref, selectionStrategy, eventMetadata);
        }
        if (ref.isSnapshot()) {
            return this.resolveFirstSnapshotRefWithLocation(locations, ref, selectionStrategy, eventMetadata);
        }
        return null;
    }

    @Override
    public List<ProjectVersionRefLocation> resolveAllVariableVersionLocations(List<? extends Location> locations, ArtifactRef ref, VersionSelectionStrategy selectionStrategy) throws TransferException {
        return this.resolveAllVariableVersionLocations(locations, ref, selectionStrategy, new EventMetadata());
    }

    @Override
    public List<ProjectVersionRefLocation> resolveAllVariableVersionLocations(List<? extends Location> locations, ArtifactRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        if (!ref.getVersionSpec().isSingle()) {
            return this.resolveAllMultiRefsWithLocations(locations, ref, selectionStrategy, eventMetadata);
        }
        if (ref.isSnapshot()) {
            return this.resolveAllSnapshotRefsWithLocations(locations, ref, selectionStrategy, eventMetadata);
        }
        return Collections.emptyList();
    }

    private ProjectVersionRef resolveLatestSnapshotRef(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        ProjectVersionRefLocation result = this.resolveLatestSnapshotRefWithLocation(locations, ref, selectionStrategy, eventMetadata);
        return result == null ? null : result.getRef();
    }

    private ProjectVersionRefLocation resolveLatestSnapshotRefWithLocation(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        TreeMap<SingleVersion, Location> available = new TreeMap<SingleVersion, Location>();
        for (Location location : locations) {
            try {
                MavenMetadataView metadata = this.metadataReader.getMetadata(ref, Collections.singletonList(location), eventMetadata);
                if (metadata == null) continue;
                this.addSnapshotFrom(metadata, location, ref, available);
            }
            catch (GalleyMavenException e) {
                this.debug("Failed to resolve/parse metadata for snapshot version of: %s from: %s.", e, ref, location);
            }
        }
        if (available.isEmpty()) {
            return null;
        }
        ArrayList<SingleVersion> versions = new ArrayList<SingleVersion>(available.keySet());
        Collections.sort(versions);
        SingleVersion singleVersion = selectionStrategy.select(versions);
        if (singleVersion == null) {
            return null;
        }
        return new ProjectVersionRefLocation(ref.selectVersion(singleVersion), (Location)available.get(singleVersion));
    }

    private ProjectVersionRef resolveFirstSnapshotRef(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        ProjectVersionRefLocation result = this.resolveFirstSnapshotRefWithLocation(locations, ref, selectionStrategy, eventMetadata);
        return result == null ? null : result.getRef();
    }

    private ProjectVersionRefLocation resolveFirstSnapshotRefWithLocation(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        for (Location location : locations) {
            TreeMap<SingleVersion, Location> available = new TreeMap<SingleVersion, Location>();
            try {
                MavenMetadataView metadata = this.metadataReader.getMetadata(ref, Collections.singletonList(location), eventMetadata);
                if (metadata != null) {
                    this.addSnapshotFrom(metadata, location, ref, available);
                }
            }
            catch (GalleyMavenException e) {
                this.debug("Failed to resolve/parse metadata for snapshot version of: %s from: %s.", e, ref, location);
            }
            if (available.isEmpty()) continue;
            ArrayList<SingleVersion> versions = new ArrayList<SingleVersion>(available.keySet());
            Collections.sort(versions);
            SingleVersion selected = selectionStrategy.select(versions);
            if (selected == null) continue;
            return new ProjectVersionRefLocation(ref.selectVersion(selected), (Location)available.get(selected));
        }
        return null;
    }

    private void addSnapshotFrom(MavenMetadataView metadata, Location location, ProjectVersionRef ref, Map<SingleVersion, Location> available) throws GalleyMavenException {
        String version = metadata.resolveSingleValue(SNAP_VERSION_XPATH);
        this.logger.debug("Latest snapshot version in metadata is: {}", (Object)version);
        if (version != null) {
            try {
                SingleVersion ver = VersionUtils.createSingleVersion(version);
                if (!available.containsKey(ver)) {
                    this.logger.debug("Found candidate snapshot: {}", (Object)ver);
                    available.put(ver, location);
                }
            }
            catch (InvalidVersionSpecificationException e) {
                this.debug("Unparsable version spec found in metadata: '%s' for: %s from: %s", e, version, ref, location);
            }
        }
    }

    private ProjectVersionRef resolveLatestMultiRef(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        ProjectVersionRefLocation result = this.resolveLatestMultiRefWithLocation(locations, ref, selectionStrategy, eventMetadata);
        return result == null ? null : result.getRef();
    }

    private ProjectVersionRefLocation resolveLatestMultiRefWithLocation(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        TreeMap<SingleVersion, Location> available = new TreeMap<SingleVersion, Location>();
        for (Location location : locations) {
            try {
                List<String> versions;
                MavenMetadataView metadata = this.metadataReader.getMetadata(ref.asProjectRef(), Collections.singletonList(location), eventMetadata);
                if (metadata == null || (versions = metadata.resolveValues("/metadata/versioning/versions/version")) == null) continue;
                for (String version : versions) {
                    try {
                        SingleVersion spec = VersionUtils.createSingleVersion(version);
                        if (available.containsKey(spec)) continue;
                        available.put(spec, location);
                    }
                    catch (InvalidVersionSpecificationException e) {
                        this.debug("Unparsable version spec found in metadata: '%s' for: %s from: %s.", e, version, ref, location);
                    }
                }
            }
            catch (GalleyMavenException e) {
                this.debug("Failed to resolve/parse metadata for variable version of: '%s' from: %s.", e, ref, location);
            }
        }
        if (!available.isEmpty()) {
            VersionSpec spec = ref.getVersionSpec();
            ArrayList<SingleVersion> arrayList = new ArrayList<SingleVersion>(available.keySet());
            Collections.sort(arrayList);
            while (!arrayList.isEmpty()) {
                SingleVersion selected = selectionStrategy.select(arrayList);
                if (selected == null) {
                    return null;
                }
                arrayList.remove(selected);
                if (!selected.isConcrete() || !spec.contains(selected)) continue;
                return new ProjectVersionRefLocation(ref.selectVersion(selected), (Location)available.get(selected));
            }
        }
        return null;
    }

    private ProjectVersionRef resolveFirstMultiRef(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        ProjectVersionRefLocation result = this.resolveFirstMultiRefWithLocation(locations, ref, selectionStrategy, eventMetadata);
        return result == null ? null : result.getRef();
    }

    private ProjectVersionRefLocation resolveFirstMultiRefWithLocation(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        for (Location location : locations) {
            SingleVersion selected;
            List<String> versions;
            TreeMap<SingleVersion, Location> available = new TreeMap<SingleVersion, Location>();
            try {
                MavenMetadataView metadata = this.metadataReader.getMetadata(ref.asProjectRef(), Collections.singletonList(location), eventMetadata);
                if (metadata != null && (versions = metadata.resolveValues("/metadata/versioning/versions/version")) != null) {
                    for (String version : versions) {
                        try {
                            SingleVersion spec = VersionUtils.createSingleVersion(version);
                            if (available.containsKey(spec)) continue;
                            available.put(spec, location);
                        }
                        catch (InvalidVersionSpecificationException e) {
                            this.debug("Unparsable version spec found in metadata: '%s' for: %s from: %s.", e, version, ref, location);
                        }
                    }
                }
            }
            catch (GalleyMavenException e) {
                this.debug("Failed to resolve/parse metadata for variable version of: '%s' from: %s.", e, ref, location);
            }
            if (available.isEmpty()) continue;
            VersionSpec spec = ref.getVersionSpec();
            versions = new ArrayList(available.keySet());
            Collections.sort(versions);
            while (!versions.isEmpty() && (selected = selectionStrategy.select(versions)) != null) {
                versions.remove(selected);
                if (!selected.isConcrete() || !spec.contains(selected)) continue;
                return new ProjectVersionRefLocation(ref.selectVersion(selected), (Location)available.get(selected));
            }
        }
        return null;
    }

    private void debug(String message, Throwable e, Object ... params) {
        final String format = message.replaceAll("\\{\\}", "%s") + "\n%s\n  %s";
        final Object[] p = new Object[params.length + 2];
        System.arraycopy(params, 0, p, 0, params.length);
        p[p.length - 2] = e.getMessage();
        p[p.length - 1] = new JoinString("\n  ", e.getStackTrace());
        this.logger.debug("{}", new Object(){

            public String toString() {
                return String.format(format, p);
            }
        });
    }

    private List<ProjectVersionRefLocation> resolveAllMultiRefsWithLocations(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        TreeMap<SingleVersion, Location> available = new TreeMap<SingleVersion, Location>();
        for (Location location : locations) {
            try {
                List<String> versions;
                MavenMetadataView metadata = this.metadataReader.getMetadata(ref.asProjectRef(), Collections.singletonList(location), eventMetadata);
                if (metadata == null || (versions = metadata.resolveValues("/metadata/versioning/versions/version")) == null) continue;
                for (String version : versions) {
                    try {
                        SingleVersion spec = VersionUtils.createSingleVersion(version);
                        if (available.containsKey(spec)) continue;
                        available.put(spec, location);
                    }
                    catch (InvalidVersionSpecificationException e) {
                        this.debug("Unparsable version spec found in metadata: '%s' for: %s from: %s.", e, version, ref, location);
                    }
                }
            }
            catch (GalleyMavenException e) {
                this.debug("Failed to resolve/parse metadata for variable version of: '%s' from: %s.", e, ref, location);
            }
        }
        if (!available.isEmpty()) {
            ArrayList<ProjectVersionRefLocation> result = new ArrayList<ProjectVersionRefLocation>();
            VersionSpec versionSpec = ref.getVersionSpec();
            ArrayList<SingleVersion> versions = new ArrayList<SingleVersion>(available.keySet());
            Collections.sort(versions);
            while (!versions.isEmpty()) {
                SingleVersion selected = selectionStrategy.select(versions);
                if (selected == null) continue;
                versions.remove(selected);
                if (!selected.isConcrete() || !versionSpec.contains(selected)) continue;
                result.add(new ProjectVersionRefLocation(ref.selectVersion(selected), (Location)available.get(selected)));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private List<ProjectVersionRefLocation> resolveAllSnapshotRefsWithLocations(List<? extends Location> locations, ProjectVersionRef ref, VersionSelectionStrategy selectionStrategy, EventMetadata eventMetadata) throws TransferException {
        TreeMap<SingleVersion, Location> available = new TreeMap<SingleVersion, Location>();
        for (Location location : locations) {
            try {
                String latest;
                MavenMetadataView metadata = this.metadataReader.getMetadata(ref, Collections.singletonList(location), eventMetadata);
                if (metadata == null || (latest = metadata.resolveSingleValue("/metadata/versioning/latest")) == null) continue;
                try {
                    SingleVersion ver = VersionUtils.createSingleVersion(latest);
                    if (!ver.isSnapshot() || available.containsKey(ver)) continue;
                    available.put(ver, location);
                }
                catch (InvalidVersionSpecificationException e) {
                    this.debug("Unparsable version spec found in metadata: '%s' for: %s from: %s", e, latest, ref, location);
                }
            }
            catch (GalleyMavenException e) {
                this.debug("Failed to resolve/parse metadata for snapshot version of: %s from: %s.", e, ref, location);
            }
        }
        if (!available.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SingleVersion> versions = new ArrayList<SingleVersion>(available.keySet());
        Collections.sort(versions);
        ArrayList<ProjectVersionRefLocation> arrayList = new ArrayList<ProjectVersionRefLocation>();
        while (!versions.isEmpty()) {
            SingleVersion selected = selectionStrategy.select(versions);
            if (selected == null) continue;
            versions.remove(selected);
            arrayList.add(new ProjectVersionRefLocation(ref.selectVersion(selected), (Location)available.get(selected)));
        }
        return arrayList;
    }
}

