/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.io.resolver.GalleyAPIWrapper;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.DependencyView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.model.view.PluginView;
import org.commonjava.maven.galley.model.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class ModelIO {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private GalleyAPIWrapper galleyWrapper;

    @Inject
    public ModelIO(GalleyAPIWrapper galleyWrapper) {
        this.galleyWrapper = galleyWrapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Model resolveRawModel(ProjectVersionRef ref) throws ManipulationException {
        Transfer transfer;
        try {
            transfer = this.galleyWrapper.resolveArtifact(ref.asPomArtifact());
        }
        catch (TransferException e) {
            throw new ManipulationException("Failed to resolve POM: %s.\n--> %s", (Throwable)e, ref, e.getMessage());
        }
        if (transfer == null) {
            throw new ManipulationException("Failed to resolve POM: " + ref.asPomArtifact(), new String[0]);
        }
        try (InputStream in = transfer.openInputStream();){
            Model model = new MavenXpp3Reader().read(in);
            return model;
        }
        catch (IOException | XmlPullParserException e) {
            throw new ManipulationException("Failed to build model for POM: %s.\n--> %s", (Throwable)e, ref, e.getMessage());
        }
    }

    public File resolveRawFile(ArtifactRef ref) throws ManipulationException {
        Transfer transfer;
        try {
            transfer = this.galleyWrapper.resolveArtifact(ref);
        }
        catch (TransferException e) {
            throw new ManipulationException("Failed to resolve POM: %s.\n--> %s", (Throwable)e, ref, e.getMessage());
        }
        if (transfer == null) {
            throw new ManipulationException("Failed to resolve POM: " + ref.asPomArtifact(), new String[0]);
        }
        return transfer.getDetachedFile();
    }

    public Map<ArtifactRef, String> getRemoteDependencyVersionOverrides(ProjectVersionRef ref) throws ManipulationException {
        this.logger.debug("Resolving dependency management GAV: " + ref);
        LinkedHashMap<ArtifactRef, String> versionOverrides = new LinkedHashMap<ArtifactRef, String>();
        try {
            MavenPomView pomView = this.galleyWrapper.readPomView(ref);
            List<DependencyView> deps = pomView.getAllManagedDependencies();
            if (deps == null || deps.isEmpty()) {
                this.logger.warn("Attempting to align to a BOM that does not have a dependencyManagement section");
            } else {
                for (DependencyView dep : deps) {
                    versionOverrides.put(dep.asArtifactRef(), dep.getVersion());
                    this.logger.debug("Added version override for: " + dep.asProjectRef().toString() + ":" + dep.getVersion());
                }
            }
        }
        catch (GalleyMavenException e) {
            throw new ManipulationException("Unable to resolve: %s", (Throwable)e, ref);
        }
        return versionOverrides;
    }

    public Map<ProjectRef, String> getRemoteDependencyVersionOverridesByProject(ProjectVersionRef ref) throws ManipulationException {
        Map<ArtifactRef, String> byArtifact = this.getRemoteDependencyVersionOverrides(ref);
        return byArtifact.entrySet().stream().collect(Collectors.toMap(e -> ((ArtifactRef)e.getKey()).asProjectRef(), Map.Entry::getValue, (key1, key2) -> key1));
    }

    public Properties getRemotePropertyMappingOverrides(ProjectVersionRef ref) throws ManipulationException {
        this.logger.debug("Resolving remote property mapping POM: " + ref);
        Model m = this.resolveRawModel(ref);
        this.logger.debug("Returning override of " + m.getProperties());
        return m.getProperties();
    }

    public Set<Plugin> getRemotePluginManagementVersionOverrides(ProjectVersionRef ref, Properties userProperties) throws ManipulationException {
        return this.getRemotePluginVersionOverrides(PluginType.PluginMgmt, ref, userProperties);
    }

    public Set<Plugin> getRemotePluginVersionOverrides(ProjectVersionRef ref, Properties userProperties) throws ManipulationException {
        return this.getRemotePluginVersionOverrides(PluginType.Plugins, ref, userProperties);
    }

    private Set<Plugin> getRemotePluginVersionOverrides(PluginType type, ProjectVersionRef ref, Properties userProperties) throws ManipulationException {
        this.logger.debug("Resolving remote {} POM: {}", (Object)type, (Object)ref);
        HashSet<Plugin> pluginOverrides = new HashSet<Plugin>();
        HashMap<ProjectRef, ProjectVersionRef> pluginOverridesPomView = new HashMap<ProjectRef, ProjectVersionRef>();
        Model m = this.resolveRawModel(ref);
        try {
            MavenPomView pomView = this.galleyWrapper.readPomView(ref);
            List<PluginView> deps = type == PluginType.PluginMgmt ? pomView.getAllManagedBuildPlugins() : pomView.getAllBuildPlugins();
            for (PluginView p : deps) {
                pluginOverridesPomView.put(p.asProjectRef(), p.asProjectVersionRef());
            }
        }
        catch (GalleyMavenException e) {
            throw new ManipulationException("Unable to resolve: %s", (Throwable)e, ref);
        }
        this.logger.debug("Found pluginOverridesResolvedVersions {} ", (Object)pluginOverridesPomView);
        for (Map.Entry entry : pluginOverridesPomView.entrySet()) {
            Plugin p = new Plugin();
            p.setArtifactId(((ProjectRef)entry.getKey()).getArtifactId());
            p.setGroupId(((ProjectRef)entry.getKey()).getGroupId());
            p.setVersion(((ProjectVersionRef)entry.getValue()).getVersionString());
            pluginOverrides.add(p);
        }
        if (m.getBuild() != null && m.getBuild().getPluginManagement() != null) {
            Iterator<Plugin> plit = null;
            if (type == PluginType.PluginMgmt && m.getBuild().getPluginManagement() != null) {
                this.logger.debug("Returning override of {}", (Object)m.getBuild().getPluginManagement().getPlugins());
                plit = m.getBuild().getPluginManagement().getPlugins().iterator();
            } else if (type == PluginType.Plugins && m.getBuild().getPlugins() != null) {
                this.logger.debug("Returning override of {}", (Object)m.getBuild().getPlugins());
                plit = m.getBuild().getPlugins().iterator();
            }
            while (plit != null && plit.hasNext()) {
                Plugin p = (Plugin)plit.next();
                SimpleProjectRef pr = new SimpleProjectRef(p.getGroupId(), p.getArtifactId());
                if (StringUtils.isNotEmpty(p.getVersion()) && p.getVersion().startsWith("${") || StringUtils.isEmpty(p.getVersion())) {
                    String newVersion = this.resolveProperty(userProperties, m.getProperties(), p.getVersion());
                    if (newVersion.startsWith("${") || newVersion.length() == 0) {
                        newVersion = ((ProjectVersionRef)pluginOverridesPomView.get(pr)).getVersionString();
                    }
                    this.logger.debug("Replacing plugin override version {} with {}", (Object)p.getVersion(), (Object)newVersion);
                    p.setVersion(newVersion);
                }
                pluginOverrides.remove(p);
                pluginOverrides.add(p);
                if (p.getConfiguration() != null) {
                    this.processChildren(userProperties, m, (Xpp3Dom)p.getConfiguration());
                }
                if (p.getExecutions() != null) {
                    List<PluginExecution> exes = p.getExecutions();
                    for (PluginExecution pe : exes) {
                        if (pe.getConfiguration() == null) continue;
                        this.processChildren(userProperties, m, (Xpp3Dom)pe.getConfiguration());
                    }
                }
                if (p.getDependencies() != null) {
                    for (Dependency d : p.getDependencies()) {
                        if (StringUtils.isEmpty(d.getVersion()) || !d.getVersion().startsWith("${")) continue;
                        this.logger.debug("Processing dependency {} and updating with {} ", (Object)d, (Object)this.resolveProperty(userProperties, m.getProperties(), d.getVersion()));
                        d.setVersion(this.resolveProperty(userProperties, m.getProperties(), d.getVersion()));
                    }
                }
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Added plugin override for {} with configuration \n{} and executions {} and dependencies {}", p.getId(), p.getExecutions(), p.getDependencies());
            }
        } else {
            throw new ManipulationException("Attempting to align to a BOM that does not have a " + type.toString() + " section", new String[0]);
        }
        return pluginOverrides;
    }

    private void processChildren(Properties userProperties, Model model, Xpp3Dom parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            String replacement;
            Xpp3Dom child = parent.getChild(i);
            if (child.getChildCount() > 0) {
                this.processChildren(userProperties, model, child);
            }
            if (child.getValue() == null || !child.getValue().startsWith("${") || (replacement = this.resolveProperty(userProperties, model.getProperties(), child.getValue())) == null || replacement.isEmpty()) continue;
            this.logger.debug("Replacing child value {} with {}", (Object)child.getValue(), (Object)replacement);
            child.setValue(replacement);
        }
    }

    private String resolveProperty(Properties userProperties, Properties p, String key) {
        String child;
        String result = "";
        String string = child = StringUtils.isEmpty(key) ? "" : key.substring(2, key.length() - 1);
        if (p.containsKey(child) && !userProperties.containsKey(child) && (result = p.getProperty(child)).startsWith("${")) {
            result = this.resolveProperty(userProperties, p, result);
        }
        return result;
    }

    private static enum PluginType {
        PluginMgmt,
        Plugins;


        public String toString() {
            switch (this) {
                case PluginMgmt: {
                    return "pluginManagement";
                }
                case Plugins: {
                    return "plugins";
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

