/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.state;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.ArtifactScopeEnum;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.core.state.State;

public class CommonState
implements State {
    private static final String TRANSITIVE_OVERRIDE_PROPERTY = "overrideTransitive";
    private static final String PROPERTY_CLASH_FAILS = "propertyClashFails";
    private static final String STRICT_ALIGNMENT = "strictAlignment";
    private static final String STRICT_VIOLATION_FAILS = "strictViolationFails";
    public static final String STRICT_ALIGNMENT_IGNORE_SUFFIX = "strictAlignmentIgnoreSuffix";
    public static final String EXCLUDED_SCOPES = "excludedScopes";
    private static final String DEPENDENCY_PROPERTY_VALIDATION = "strictPropertyValidation";
    private final boolean overrideTransitive;
    private final boolean propertyClashFails;
    private final boolean strict;
    private final boolean failOnStrictViolation;
    private final boolean strictIgnoreSuffix;
    private final Integer strictDependencyPluginPropertyValidation;
    private final List<String> excludedScopes;

    public CommonState(Properties userProps) throws ManipulationException {
        this.overrideTransitive = Boolean.valueOf(userProps.getProperty(TRANSITIVE_OVERRIDE_PROPERTY, "false"));
        this.propertyClashFails = Boolean.valueOf(userProps.getProperty(PROPERTY_CLASH_FAILS, "true"));
        this.strict = Boolean.valueOf(userProps.getProperty(STRICT_ALIGNMENT, "true"));
        this.strictIgnoreSuffix = Boolean.valueOf(userProps.getProperty(STRICT_ALIGNMENT_IGNORE_SUFFIX, "true"));
        this.failOnStrictViolation = Boolean.valueOf(userProps.getProperty(STRICT_VIOLATION_FAILS, "false"));
        this.excludedScopes = Arrays.asList(userProps.getProperty(EXCLUDED_SCOPES, "").length() > 0 ? userProps.getProperty(EXCLUDED_SCOPES).split(",") : new String[]{});
        for (String s : this.excludedScopes) {
            try {
                ArtifactScopeEnum.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                throw new ManipulationException("Illegal scope value " + s, new String[0]);
            }
        }
        switch (userProps.getProperty(DEPENDENCY_PROPERTY_VALIDATION, "false").toUpperCase()) {
            case "TRUE": {
                this.strictDependencyPluginPropertyValidation = 1;
                break;
            }
            case "FALSE": {
                this.strictDependencyPluginPropertyValidation = 0;
                break;
            }
            case "REVERT": {
                this.strictDependencyPluginPropertyValidation = 2;
                break;
            }
            default: {
                this.strictDependencyPluginPropertyValidation = 0;
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    public boolean isOverrideTransitive() {
        return this.overrideTransitive;
    }

    public boolean isPropertyClashFails() {
        return this.propertyClashFails;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isFailOnStrictViolation() {
        return this.failOnStrictViolation;
    }

    public boolean isStrictIgnoreSuffix() {
        return this.strictIgnoreSuffix;
    }

    public Integer getStrictDependencyPluginPropertyValidation() {
        return this.strictDependencyPluginPropertyValidation;
    }

    public List<String> getExcludedScopes() {
        return this.excludedScopes;
    }
}

