/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version {
    private static final Logger logger = LoggerFactory.getLogger(Version.class);
    private static final String EMPTY_STRING = "";
    private static final Character[] DEFAULT_DELIMITERS = new Character[]{Character.valueOf('.'), Character.valueOf('-'), Character.valueOf('_')};
    private static final String OSGI_VERSION_DELIMITER = ".";
    private static final String OSGI_QUALIFIER_DELIMITER = "-";
    private static final String DEFAULT_DELIMITER = ".";
    private static final String DEFAULT_QUALIFIER_DELIMITER = "-";
    private static final List<Character> versionStringDelimiters = Arrays.asList(DEFAULT_DELIMITERS);
    private static final String DELIMITER_REGEX = "[.\\-_]";
    private static final String LEADING_DELIMITER_REGEX = "^[.\\-_]";
    private static final String MMM_REGEX = "(\\d+)([.\\-_](\\d+)([.\\-_](\\d+))?)?";
    private static final Pattern mmmPattern = Pattern.compile("(\\d+)([.\\-_](\\d+)([.\\-_](\\d+))?)?");
    private static final String SNAPSHOT_SUFFIX = "SNAPSHOT";
    private static final String SNAPSHOT_REGEX = "(.*?)(([.\\-_])?((?i:SNAPSHOT)))$";
    private static final Pattern snapshotPattern = Pattern.compile("(.*?)(([.\\-_])?((?i:SNAPSHOT)))$");
    private static final String QUALIFIER_REGEX = "(.*?)(([.\\-_])?(\\d+))?(([.\\-_])?((?i:SNAPSHOT)))?$";
    private static final Pattern qualifierPattern = Pattern.compile("(.*?)(([.\\-_])?(\\d+))?(([.\\-_])?((?i:SNAPSHOT)))?$");
    private static final String VERSION_REGEX = "((\\d+)([.\\-_](\\d+)([.\\-_](\\d+))?)?)(([.\\-_])?((.*?)(([.\\-_])?(\\d+))?(([.\\-_])?((?i:SNAPSHOT)))?$))";
    private static final Pattern versionPattern = Pattern.compile("((\\d+)([.\\-_](\\d+)([.\\-_](\\d+))?)?)(([.\\-_])?((.*?)(([.\\-_])?(\\d+))?(([.\\-_])?((?i:SNAPSHOT)))?$))");
    private static final String OSGI_VERSION_REGEX = "(\\d+)(\\.\\d+(\\.\\d+(\\.[\\w\\-_]+)?)?)?";
    private static final Pattern osgiPattern = Pattern.compile("(\\d+)(\\.\\d+(\\.\\d+(\\.[\\w\\-_]+)?)?)?");

    private Version() {
    }

    public static String getBuildNumber(String version) {
        Matcher qualifierMatcher = qualifierPattern.matcher(Version.getQualifier(version));
        if (qualifierMatcher.matches() && !Version.isEmpty(qualifierMatcher.group(4))) {
            return qualifierMatcher.group(4);
        }
        return EMPTY_STRING;
    }

    public static int getBuildNumberPadding(int incrementalSerialSuffixPadding, Set<String> versions) {
        int result = incrementalSerialSuffixPadding;
        if (result == 0) {
            result = Version.getBuildNumber(versions.stream().max(Comparator.comparing(v -> Version.getBuildNumber(v).length())).orElse(EMPTY_STRING)).length();
        }
        logger.debug("Returning padding of {} ", (Object)result);
        return result;
    }

    public static String getMMM(String version) {
        Matcher versionMatcher = versionPattern.matcher(version);
        if (versionMatcher.matches()) {
            return versionMatcher.group(1);
        }
        return EMPTY_STRING;
    }

    static String getOsgiMMM(String version, boolean fill) {
        String mmm = Version.getMMM(version);
        Matcher mmmMatcher = mmmPattern.matcher(mmm);
        if (mmmMatcher.matches()) {
            String osgiMMM = mmmMatcher.group(1);
            String minorVersion = mmmMatcher.group(3);
            if (!Version.isEmpty(minorVersion)) {
                osgiMMM = osgiMMM + "." + minorVersion;
            } else if (fill) {
                osgiMMM = osgiMMM + ".0";
            }
            String microVersion = mmmMatcher.group(5);
            if (!Version.isEmpty(microVersion)) {
                osgiMMM = osgiMMM + "." + microVersion;
            } else if (fill) {
                osgiMMM = osgiMMM + ".0";
            }
            return osgiMMM;
        }
        return EMPTY_STRING;
    }

    public static String getOsgiVersion(String version) {
        String mmm;
        String qualifier = Version.getQualifier(version);
        if (!Version.isEmpty(qualifier)) {
            qualifier = "." + qualifier.replace(".", "-");
        }
        if (Version.isEmpty(mmm = Version.getOsgiMMM(version, !Version.isEmpty(qualifier)))) {
            logger.warn("Unable to parse version for OSGi: {}", (Object)version);
            return version;
        }
        return mmm + qualifier;
    }

    public static String getQualifier(String version) {
        Matcher versionMatcher = versionPattern.matcher(version);
        if (versionMatcher.matches()) {
            return versionMatcher.group(9);
        }
        return Version.removeLeadingDelimiter(version);
    }

    public static String getQualifierBase(String version) {
        Matcher versionMatcher = versionPattern.matcher(version);
        if (versionMatcher.matches()) {
            return versionMatcher.group(10);
        }
        Matcher qualifierMatcher = qualifierPattern.matcher(version);
        if (qualifierMatcher.matches()) {
            return qualifierMatcher.group(1);
        }
        return Version.removeLeadingDelimiter(version);
    }

    public static String getQualifierWithDelim(String version) {
        Matcher versionMatcher = versionPattern.matcher(version);
        if (versionMatcher.matches()) {
            return versionMatcher.group(7);
        }
        return version;
    }

    public static String getSnapshot(String version) {
        Matcher snapshotMatcher = snapshotPattern.matcher(version);
        if (snapshotMatcher.matches()) {
            return snapshotMatcher.group(4);
        }
        return EMPTY_STRING;
    }

    public static String getSnapshotWithDelim(String version) {
        Matcher snapshotMatcher = snapshotPattern.matcher(version);
        if (snapshotMatcher.matches()) {
            return snapshotMatcher.group(2);
        }
        return EMPTY_STRING;
    }

    public static boolean hasBuildNumber(String version) {
        return !Version.isEmpty(Version.getBuildNumber(version));
    }

    public static boolean hasQualifier(String version) {
        return !Version.isEmpty(Version.getQualifier(version));
    }

    public static boolean isEmpty(String string) {
        return string == null || EMPTY_STRING.equals(string.trim());
    }

    public static boolean isSnapshot(String version) {
        Matcher snapshotMatcher = snapshotPattern.matcher(version);
        return snapshotMatcher.matches();
    }

    public static boolean isValidOSGi(String version) {
        return osgiPattern.matcher(version).matches();
    }

    public static String removeBuildNumber(String version) {
        Matcher qualifierMatcher = qualifierPattern.matcher(version);
        if (qualifierMatcher.matches()) {
            return qualifierMatcher.replaceFirst("$1$5");
        }
        return version;
    }

    public static String removeSnapshot(String version) {
        Matcher snapshotMatcher = snapshotPattern.matcher(version);
        if (snapshotMatcher.matches()) {
            return snapshotMatcher.group(1);
        }
        return version;
    }

    private static boolean hasLeadingDelimiter(String versionPart) {
        if (versionPart.length() < 1) {
            return false;
        }
        return versionStringDelimiters.contains(Character.valueOf(versionPart.charAt(0)));
    }

    static String removeLeadingDelimiter(String versionPart) {
        return versionPart.replaceAll(LEADING_DELIMITER_REGEX, EMPTY_STRING);
    }

    private static String prependDelimiter(String versionPart, String delimiter) {
        if (Version.hasLeadingDelimiter(versionPart)) {
            return versionPart;
        }
        return delimiter + versionPart;
    }

    private static boolean isNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String appendQualifierSuffix(String version, String suffix) {
        logger.debug("Applying suffix: " + suffix + " to version " + version);
        if (Version.isEmpty(suffix)) {
            return version;
        }
        if (Version.isEmpty(Version.getQualifier(version))) {
            return version + Version.prependDelimiter(suffix, ".");
        }
        Matcher suffixMatcher = Version.createSuffixMatcher(version, suffix);
        if (suffixMatcher.matches()) {
            return version;
        }
        String suffixWoSnapshot = Version.removeSnapshot(suffix);
        String suffixBuildNumber = Version.getBuildNumber(suffix);
        String suffixWoBuildNumber = Version.removeBuildNumber(suffixWoSnapshot);
        String suffixWoBuildNumDelim = Version.removeLeadingDelimiter(suffixWoBuildNumber);
        Matcher suffixWoDelimMatcher = Version.createSuffixMatcher(version, suffixWoBuildNumDelim);
        if (suffixWoDelimMatcher.matches()) {
            String newVersion = suffixWoDelimMatcher.replaceFirst("$1$2" + suffixWoBuildNumber + "$4$7");
            if (Version.hasLeadingDelimiter(suffix)) {
                newVersion = suffixWoDelimMatcher.replaceFirst("$1" + suffixWoBuildNumber + "$4$7");
            }
            if (!Version.isEmpty(suffixBuildNumber)) {
                newVersion = Version.setBuildNumber(newVersion, suffixBuildNumber);
            }
            if (Version.isSnapshot(suffix)) {
                newVersion = Version.setSnapshot(newVersion, true);
            }
            return newVersion;
        }
        Matcher qualifierMatcher = qualifierPattern.matcher(version);
        if (qualifierMatcher.matches()) {
            if (Version.hasLeadingDelimiter(suffixWoSnapshot)) {
                String newVersion = qualifierMatcher.replaceFirst("$1$3$4" + suffixWoSnapshot + "$5");
                if (Version.isSnapshot(suffix)) {
                    newVersion = Version.setSnapshot(newVersion, true);
                }
                return newVersion;
            }
            String delimiter = "-";
            if (Version.isEmpty(Version.getQualifierBase(version))) {
                delimiter = ".";
            }
            String newVersion = qualifierMatcher.replaceFirst("$1$3$4" + delimiter + suffixWoSnapshot + "$5");
            if (Version.isSnapshot(suffix)) {
                newVersion = Version.setSnapshot(newVersion, true);
            }
            return newVersion;
        }
        return version;
    }

    private static Matcher createSuffixMatcher(String version, String suffix) {
        String SUFFIX_REGEX = "(.*?)([.\\-_])?(" + suffix + ")((" + DELIMITER_REGEX + ")?(\\d+))?((" + DELIMITER_REGEX + ")?((?i:" + SNAPSHOT_SUFFIX + ")))?$";
        return Pattern.compile(SUFFIX_REGEX).matcher(version);
    }

    public static String setBuildNumber(String version, String buildNumber) {
        if (!Version.isNumeric(buildNumber)) {
            logger.warn("Failed attempt to set non-numeric build number '{}' for version '{}'", (Object)buildNumber, (Object)version);
            return version;
        }
        if (Version.isEmpty(buildNumber)) {
            buildNumber = EMPTY_STRING;
        }
        if (Version.isEmpty(Version.getQualifier(version))) {
            return version + "." + buildNumber;
        }
        Matcher qualifierMatcher = qualifierPattern.matcher(version);
        if (qualifierMatcher.matches()) {
            if (Version.isEmpty(qualifierMatcher.group(2))) {
                buildNumber = Version.prependDelimiter(buildNumber, "-");
            }
            return qualifierMatcher.replaceFirst("$1$3" + buildNumber + "$5");
        }
        return version;
    }

    public static String setSnapshot(String version, boolean snapshot) {
        if (Version.isEmpty(version)) {
            return EMPTY_STRING;
        }
        if (Version.isSnapshot(version) == snapshot) {
            return version;
        }
        if (snapshot) {
            return version + "-" + SNAPSHOT_SUFFIX;
        }
        return Version.removeSnapshot(version);
    }

    public static int findHighestMatchingBuildNumber(String version, Set<String> versionSet) {
        int highestBuildNum = 0;
        String osgiVersion = Version.getOsgiVersion(version);
        String qualifier = Version.getQualifier(osgiVersion);
        Matcher qualifierMatcher = qualifierPattern.matcher(qualifier);
        if (qualifierMatcher.matches()) {
            qualifier = Version.removeLeadingDelimiter(qualifierMatcher.group(1));
        }
        StringBuilder versionPatternBuf = new StringBuilder();
        versionPatternBuf.append('(').append(Pattern.quote(Version.getMMM(version))).append('(').append(DELIMITER_REGEX).append("0)*").append(")?").append(DELIMITER_REGEX);
        if (!Version.isEmpty(qualifier)) {
            versionPatternBuf.append(Pattern.quote(qualifier));
            versionPatternBuf.append(DELIMITER_REGEX);
        }
        versionPatternBuf.append("(\\d+)");
        String candidatePatternStr = versionPatternBuf.toString();
        logger.debug("Using pattern: '{}' to find compatible versions from metadata.", (Object)candidatePatternStr);
        Pattern candidateSuffixPattern = Pattern.compile(candidatePatternStr);
        for (String compareVersion : versionSet) {
            String buildNumberStr;
            int compareBuildNum;
            Matcher candidateSuffixMatcher = candidateSuffixPattern.matcher(compareVersion);
            if (!candidateSuffixMatcher.matches() || (compareBuildNum = Integer.parseInt(buildNumberStr = candidateSuffixMatcher.group(3))) <= highestBuildNum) continue;
            highestBuildNum = compareBuildNum;
        }
        logger.debug("Found highest matching build number {} from set {} ", (Object)highestBuildNum, (Object)versionSet);
        return highestBuildNum;
    }

    public static int getIntegerBuildNumber(String version) {
        String buildNumber = Version.getBuildNumber(version);
        if (Version.isEmpty(buildNumber)) {
            return 0;
        }
        try {
            return Integer.parseInt(buildNumber);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }
}

