/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.BOMInjectingState;
import org.commonjava.maven.ext.core.util.IdUtils;
import org.commonjava.maven.ext.io.PomIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="bom-builder")
@Singleton
public class BOMBuilderManipulator
implements Manipulator {
    private static final String POM_DEPLOYER_GID = "org.goots.maven.plugins";
    private static final String POM_DEPLOYER_AID = "pom-deployer-maven-plugin";
    private static final String POM_DEPLOYER_VID = "1.2";
    private static final String POM_DEPLOYER_COORD = IdUtils.ga("org.goots.maven.plugins", "pom-deployer-maven-plugin");
    private static final String IDBOM = "pme-bom";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PomIO pomIO;
    private ManipulationSession session;

    @Inject
    public BOMBuilderManipulator(PomIO pomIO) {
        this.pomIO = pomIO;
    }

    @Override
    public void init(ManipulationSession session) {
        this.session = session;
        session.setState(new BOMInjectingState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        BOMInjectingState state = this.session.getState(BOMInjectingState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        List<Dependency> projectArtifacts = this.getArtifacts(projects);
        for (Project project : projects) {
            if (!project.isExecutionRoot()) continue;
            this.logger.info("Examining {} to add BOM generation.", (Object)project);
            Model model = project.getModel();
            Build build = model.getBuild();
            if (build == null) {
                build = new Build();
                model.setBuild(build);
            }
            Model bomModel = this.createModel(project, IDBOM);
            bomModel.setDescription("PME Generated BOM for other projects to use to align to.");
            DependencyManagement dm = new DependencyManagement();
            dm.setDependencies(projectArtifacts);
            bomModel.setDependencyManagement(dm);
            File pmebom = new File(this.session.getTargetDir(), "pme-bom.xml");
            this.session.getTargetDir().mkdir();
            this.pomIO.writeModel(bomModel, pmebom);
            Map<String, Plugin> pluginMap = build.getPluginsAsMap();
            if (!pluginMap.containsKey(POM_DEPLOYER_COORD)) {
                PluginExecution execution = new PluginExecution();
                execution.setId(IDBOM);
                execution.setPhase("install");
                execution.setGoals(Collections.singletonList("add-pom"));
                Plugin plugin = new Plugin();
                plugin.setGroupId(POM_DEPLOYER_GID);
                plugin.setArtifactId(POM_DEPLOYER_AID);
                plugin.setVersion(POM_DEPLOYER_VID);
                plugin.addExecution(execution);
                plugin.setInherited(false);
                build.addPlugin(plugin);
                Xpp3Dom xml = new Xpp3Dom("configuration");
                HashMap<String, Object> config = new HashMap<String, Object>();
                config.put("pomName", "target" + File.separatorChar + pmebom.getName());
                config.put("errorOnMissing", false);
                config.put("artifactId", bomModel.getArtifactId());
                config.put("groupId", bomModel.getGroupId());
                for (Map.Entry entry : config.entrySet()) {
                    Xpp3Dom child = new Xpp3Dom((String)entry.getKey());
                    if (entry.getValue() != null) {
                        child.setValue(entry.getValue().toString());
                    }
                    xml.addChild(child);
                }
                execution.setConfiguration(xml);
            }
            return Collections.singleton(project);
        }
        return Collections.emptySet();
    }

    private Model createModel(Project project, String s) {
        Model newModel = new Model();
        newModel.setModelVersion(project.getModel().getModelVersion());
        newModel.setGroupId(project.getGroupId() + '.' + project.getArtifactId());
        newModel.setArtifactId(s);
        newModel.setVersion(project.getVersion());
        newModel.setPackaging("pom");
        return newModel;
    }

    private List<Dependency> getArtifacts(List<Project> projects) {
        ArrayList<Dependency> results = new ArrayList<Dependency>();
        for (Project p : projects) {
            Dependency d = new Dependency();
            d.setGroupId(p.getGroupId());
            d.setArtifactId(p.getArtifactId());
            d.setVersion(p.getVersion());
            d.setType(p.getModel().getPackaging());
            results.add(d);
        }
        return results;
    }

    @Override
    public int getExecutionIndex() {
        return 80;
    }
}

