/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.io.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.maven.io.util.IndentationCounter;
import org.apache.maven.model.PatternSet;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.DefaultJDOMFactory;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;

public final class WriterUtils {
    private static final String INDENT = "  ";
    private static final String lineSeparator = "\n";
    private static final DefaultJDOMFactory factory = new DefaultJDOMFactory();

    private WriterUtils() {
    }

    public static Element updateElement(IndentationCounter counter, Element parent, String name, boolean shouldExist) {
        Element element = parent.getChild(name, parent.getNamespace());
        if (shouldExist) {
            if (element == null) {
                element = factory.element(name, parent.getNamespace());
                WriterUtils.insertAtPreferredLocation(parent, element, counter);
            }
            counter.increaseCount();
        } else if (element != null) {
            Text txt;
            Content previous;
            int index = parent.indexOf(element);
            if (index > 0 && (previous = parent.getContent(index - 1)) instanceof Text && (txt = (Text)previous).getTextTrim().length() == 0) {
                parent.removeContent(txt);
            }
            parent.removeContent(element);
        }
        return element;
    }

    public static Element findAndReplaceXpp3DOM(IndentationCounter counter, Element parent, String name, Xpp3Dom dom) {
        boolean shouldExist = dom != null && (dom.getChildCount() > 0 || dom.getValue() != null);
        Element element = WriterUtils.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            WriterUtils.replaceXpp3DOM(element, dom, new IndentationCounter(counter.getDepth() + 1));
        }
        return element;
    }

    public static void replaceXpp3DOM(Element parent, Xpp3Dom parentDom, IndentationCounter counter) {
        if (parentDom.getChildCount() > 0) {
            Xpp3Dom[] childs = parentDom.getChildren();
            ArrayList<Xpp3Dom> domChilds = new ArrayList<Xpp3Dom>();
            for (Xpp3Dom child : childs) {
                domChilds.add(child);
            }
            ListIterator<Element> it = parent.getChildren().listIterator();
            while (it.hasNext()) {
                Element elem = it.next();
                Iterator it2 = domChilds.iterator();
                Xpp3Dom corrDom = null;
                while (it2.hasNext()) {
                    Xpp3Dom dm = (Xpp3Dom)it2.next();
                    if (!dm.getName().equals(elem.getName())) continue;
                    corrDom = dm;
                    break;
                }
                if (corrDom != null) {
                    domChilds.remove(corrDom);
                    WriterUtils.replaceXpp3DOM(elem, corrDom, new IndentationCounter(counter.getDepth() + 1));
                    counter.increaseCount();
                    continue;
                }
                it.remove();
            }
            for (Xpp3Dom dm : domChilds) {
                String[] attributeNames;
                Element elem;
                String rawName = dm.getName();
                String[] parts = rawName.split(":");
                if (parts.length > 1) {
                    String nsId = parts[0];
                    String nsUrl = dm.getAttribute("xmlns:" + nsId);
                    String name = parts[1];
                    if (nsUrl == null) {
                        nsUrl = parentDom.getAttribute("xmlns:" + nsId);
                    }
                    elem = factory.element(name, Namespace.getNamespace(nsId, nsUrl));
                } else {
                    Namespace root = parent.getNamespace();
                    for (Namespace n : parent.getNamespacesInherited()) {
                        if (n.getPrefix() != null && n.getPrefix().length() != 0) continue;
                        root = n;
                        break;
                    }
                    elem = factory.element(dm.getName(), root);
                }
                for (String attrName : attributeNames = dm.getAttributeNames()) {
                    if (attrName.startsWith("xmlns:")) continue;
                    elem.setAttribute(attrName, dm.getAttribute(attrName));
                }
                WriterUtils.insertAtPreferredLocation(parent, elem, counter);
                counter.increaseCount();
                WriterUtils.replaceXpp3DOM(elem, dm, new IndentationCounter(counter.getDepth() + 1));
            }
        } else if (parentDom.getValue() != null) {
            List<Content> cl = parent.getContent();
            boolean foundCdata = false;
            for (Content c : cl) {
                if (!(c instanceof CDATA)) continue;
                foundCdata = true;
            }
            if (!foundCdata) {
                parent.setText(parentDom.getValue());
            }
        }
    }

    public static void insertAtPreferredLocation(Element parent, Element child, IndentationCounter counter) {
        int contentIndex = 0;
        int elementCounter = 0;
        Iterator<Content> it = parent.getContent().iterator();
        Text lastText = null;
        int offset = 0;
        while (it.hasNext() && elementCounter <= counter.getCurrentIndex()) {
            Content next = it.next();
            ++offset;
            if (next instanceof Element) {
                ++elementCounter;
                contentIndex += offset;
                offset = 0;
            }
            if (!(next instanceof Text) || !it.hasNext()) continue;
            lastText = (Text)next;
        }
        if (lastText != null && lastText.getTextTrim().length() == 0) {
            lastText = lastText.clone();
        } else {
            String starter = lineSeparator;
            for (int i = 0; i < counter.getDepth(); ++i) {
                starter = starter + INDENT;
            }
            lastText = factory.text(starter);
        }
        if (parent.getContentSize() == 0) {
            Text finalText = lastText.clone();
            finalText.setText(finalText.getText().substring(0, finalText.getText().length() - INDENT.length()));
            parent.addContent(contentIndex, finalText);
        }
        parent.addContent(contentIndex, child);
        parent.addContent(contentIndex, lastText);
    }

    public static Element findAndReplaceProperties(IndentationCounter counter, Element parent, String name, Map props) {
        boolean shouldExist = props != null && !props.isEmpty();
        Element element = WriterUtils.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            Iterator<Object> it = props.keySet().iterator();
            IndentationCounter innerCounter = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                String key = (String)it.next();
                WriterUtils.findAndReplaceSimpleElement(innerCounter, element, key, (String)props.get(key), null);
            }
            ArrayList lst = new ArrayList(props.keySet());
            it = element.getChildren().iterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                String key = elem.getName();
                if (lst.contains(key)) continue;
                it.remove();
            }
        }
        return element;
    }

    public static Element findAndReplaceSimpleElement(IndentationCounter counter, Element parent, String name, String text, String defaultValue) {
        Element element;
        if (defaultValue != null && text != null && defaultValue.equals(text) && ((element = parent.getChild(name, parent.getNamespace())) != null && defaultValue.equals(element.getText()) || element == null)) {
            return element;
        }
        boolean shouldExist = text != null && text.trim().length() >= 0;
        Element element2 = WriterUtils.updateElement(counter, parent, name, shouldExist);
        if (shouldExist) {
            element2.setText(text);
        }
        return element2;
    }

    public static Element findAndReplaceSimpleLists(IndentationCounter counter, Element parent, Collection list, String parentName, String childName) {
        boolean shouldExist = list != null && list.size() > 0;
        Element element = WriterUtils.updateElement(counter, parent, parentName, shouldExist);
        if (shouldExist) {
            Iterator it = list.iterator();
            Iterator<Element> elIt = element.getChildren(childName, element.getNamespace()).iterator();
            if (!elIt.hasNext()) {
                elIt = null;
            }
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            while (it.hasNext()) {
                Element el;
                String value = (String)it.next();
                if (elIt != null && elIt.hasNext()) {
                    el = elIt.next();
                    if (!elIt.hasNext()) {
                        elIt = null;
                    }
                } else {
                    el = factory.element(childName, element.getNamespace());
                    WriterUtils.insertAtPreferredLocation(element, el, innerCount);
                }
                el.setText(value);
                innerCount.increaseCount();
            }
            if (elIt != null) {
                while (elIt.hasNext()) {
                    elIt.next();
                    elIt.remove();
                }
            }
        }
        return element;
    }

    public static void updatePatternSet(PatternSet patternSet, String xmlTag, IndentationCounter counter, Element element) {
        boolean shouldExist = patternSet != null;
        Element root = WriterUtils.updateElement(counter, element, xmlTag, shouldExist);
        if (shouldExist) {
            IndentationCounter innerCount = new IndentationCounter(counter.getDepth() + 1);
            WriterUtils.findAndReplaceSimpleLists(innerCount, root, patternSet.getIncludes(), "includes", "include");
            WriterUtils.findAndReplaceSimpleLists(innerCount, root, patternSet.getExcludes(), "excludes", "exclude");
        }
    }
}

