/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.set.mavendependencyupdater;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.version.Version;
import org.jboss.logging.Logger;
import org.jboss.set.mavendependencyupdater.AvailableVersionsResolver;
import org.jboss.set.mavendependencyupdater.VersionStream;
import org.jboss.set.mavendependencyupdater.common.ident.ScopedArtifactRef;
import org.jboss.set.mavendependencyupdater.configuration.Configuration;
import org.jboss.set.mavendependencyupdater.rules.NeverRestriction;
import org.jboss.set.mavendependencyupdater.rules.Restriction;
import org.jboss.set.mavendependencyupdater.rules.TokenizedVersion;
import org.jboss.set.mavendependencyupdater.rules.VersionPrefixRestriction;
import org.jboss.set.mavendependencyupdater.rules.VersionStreamRestriction;

public class DependencyEvaluator {
    private static final Logger LOG = Logger.getLogger(DependencyEvaluator.class);
    private static final VersionStreamRestriction DEFAULT_STREAM_RESTRICTION = new VersionStreamRestriction(VersionStream.MICRO);
    private Configuration configuration;
    private AvailableVersionsResolver availableVersionsResolver;
    private boolean configUpToDate;

    public DependencyEvaluator(Configuration configuration, AvailableVersionsResolver availableVersionsResolver) {
        this.configuration = configuration;
        this.availableVersionsResolver = availableVersionsResolver;
    }

    public List<ComponentUpgrade> getVersionsToUpgrade(Collection<ScopedArtifactRef> dependencies) {
        ArrayList<ComponentUpgrade> versionsToUpgrade = new ArrayList<ComponentUpgrade>();
        this.configUpToDate = true;
        for (ScopedArtifactRef dep : dependencies) {
            Artifact rangeArtifact = DependencyEvaluator.toVersionRangeArtifact(dep);
            if (dep.getVersionString().startsWith("$")) {
                LOG.warnf("Skipping dependency '%s', should this be resolved?", (Object)dep);
                continue;
            }
            if (this.configuration.getIgnoreScopes().contains(dep.getScope())) {
                LOG.debugf("Skipping dependency '%s', scope '%s' is ignored", (Object)dep, (Object)dep.getScope());
                continue;
            }
            try {
                List<Restriction> restrictions = this.configuration.getRestrictionsFor(dep.getGroupId(), dep.getArtifactId());
                VersionRangeResult versionRangeResult = this.availableVersionsResolver.resolveVersionRange(rangeArtifact);
                Optional<Version> latest = this.findLatest(dep, restrictions, versionRangeResult.getVersions());
                LOG.debugf("Available versions for '%s': %s", (Object)dep, (Object)versionRangeResult);
                if (latest.isPresent() && !dep.getVersionString().equals(latest.get().toString())) {
                    String latestStr = latest.get().toString();
                    String repoId = versionRangeResult.getRepository(latest.get()).getId();
                    LOG.infof("Found possible upgrade of '%s' to '%s' in repo '%s'", (Object)dep, (Object)latestStr, (Object)repoId);
                    versionsToUpgrade.add(new ComponentUpgrade(dep, latestStr, repoId));
                    continue;
                }
                LOG.debugf("  => no change", new Object[0]);
            }
            catch (RepositoryException e) {
                LOG.errorf("Could not resolve '%s'", (Object)rangeArtifact.toString());
            }
        }
        if (!this.configUpToDate) {
            LOG.warn("Configuration not up to date? Check the warnings above.");
        }
        return versionsToUpgrade;
    }

    private static Artifact toVersionRangeArtifact(ArtifactRef ref) {
        return new DefaultArtifact(ref.getGroupId(), ref.getArtifactId(), null, "[" + ref.getVersionString() + ",)");
    }

    Optional<Version> findLatest(ScopedArtifactRef dependency, List<Restriction> restrictions, List<Version> availableVersions) {
        VersionPrefixRestriction prefixRestriction;
        if (restrictions.stream().anyMatch(r -> r instanceof NeverRestriction)) {
            return Optional.empty();
        }
        Optional<Restriction> prefixRestrictionOptional = restrictions.stream().filter(r -> r instanceof VersionPrefixRestriction).findFirst();
        boolean restrictedPrefix = prefixRestrictionOptional.isPresent();
        boolean restrictedStream = restrictions.stream().anyMatch(r -> r instanceof VersionStreamRestriction);
        if (restrictedPrefix && !(prefixRestriction = (VersionPrefixRestriction)prefixRestrictionOptional.get()).applies(dependency.getVersionString(), dependency.getVersionString())) {
            LOG.warnf("Existing dependency '%s' doesn't match configured prefix: '%s'", (Object)dependency, (Object)prefixRestriction.getPrefixString());
            this.configUpToDate = false;
            return Optional.empty();
        }
        Stream<Object> workingStream = availableVersions.stream();
        if (!restrictedPrefix && !restrictedStream) {
            workingStream = workingStream.filter(v -> DEFAULT_STREAM_RESTRICTION.applies(v.toString(), dependency.getVersionString()));
        }
        for (Restriction restriction : restrictions) {
            workingStream = workingStream.filter(v -> restriction.applies(v.toString(), dependency.getVersionString()));
        }
        return workingStream.max(Comparator.comparing(v -> TokenizedVersion.parse(v.toString())));
    }

    public static class ComponentUpgrade {
        private ArtifactRef artifact;
        private String newVersion;
        private String repository;

        public ComponentUpgrade(ArtifactRef artifact, String newVersion, String repository) {
            this.artifact = artifact;
            this.newVersion = newVersion;
            this.repository = repository;
        }

        public ArtifactRef getArtifact() {
            return this.artifact;
        }

        public String getNewVersion() {
            return this.newVersion;
        }

        public String getRepository() {
            return this.repository;
        }

        public String toString() {
            return this.artifact.getGroupId() + ":" + this.artifact.getArtifactId() + ":" + this.artifact.getVersionString() + " -> " + this.newVersion;
        }
    }
}

