/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.util;

import org.commonjava.maven.galley.event.EventMetadata;

public final class PathUtils {
    public static final String ROOT = "/";
    private static final String[] ROOT_ARRY = new String[]{"/"};

    private PathUtils() {
    }

    public static String[] parentPath(String path) {
        String[] parts = path.split(ROOT);
        if (parts.length < 2) {
            return ROOT_ARRY;
        }
        String[] parentParts = new String[parts.length - 1];
        System.arraycopy(parts, 0, parentParts, 0, parentParts.length);
        return parentParts;
    }

    public static String normalize(String ... path) {
        if (path == null || path.length < 1 || path.length == 1 && path[0] == null) {
            return ROOT;
        }
        StringBuilder sb = new StringBuilder();
        int idx = 0;
        block0: for (String part : path) {
            if (part == null || part.length() < 1 || ROOT.equals(part)) continue;
            if (idx == 0 && part.startsWith("file:")) {
                if (part.length() <= 5) continue;
                sb.append(part.substring(5));
                continue;
            }
            if (idx > 0) {
                while (part.charAt(0) == '/') {
                    if (part.length() < 2) continue block0;
                    part = part.substring(1);
                }
            }
            while (part.charAt(part.length() - 1) == '/') {
                if (part.length() < 2) continue block0;
                part = part.substring(0, part.length() - 1);
            }
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append(part);
            ++idx;
        }
        if (path[path.length - 1] != null && path[path.length - 1].endsWith(ROOT)) {
            sb.append(ROOT);
        }
        return sb.toString();
    }

    public static String storagePath(String path, EventMetadata eventMetadata) {
        String storage = (String)eventMetadata.get("storage-path");
        return storage == null ? path : PathUtils.normalize(storage);
    }
}

