/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.rel;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.commonjava.maven.atlas.graph.model.EProjectDirectRelationships;
import org.commonjava.maven.atlas.graph.rel.SimpleBomRelationship;
import org.commonjava.maven.atlas.graph.rel.SimpleDependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.SimpleExtensionRelationship;
import org.commonjava.maven.atlas.graph.rel.SimpleParentRelationship;
import org.commonjava.maven.atlas.graph.rel.SimplePluginDependencyRelationship;
import org.commonjava.maven.atlas.graph.rel.SimplePluginRelationship;
import org.commonjava.maven.atlas.graph.util.RelationshipUtils;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.InvalidRefException;
import org.commonjava.maven.atlas.ident.ref.ProjectRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.atlas.ident.util.JoinString;
import org.commonjava.maven.atlas.ident.version.InvalidVersionSpecificationException;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.DependencyView;
import org.commonjava.maven.galley.maven.model.view.ExtensionView;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.model.view.ParentView;
import org.commonjava.maven.galley.maven.model.view.PluginDependencyView;
import org.commonjava.maven.galley.maven.model.view.PluginView;
import org.commonjava.maven.galley.maven.model.view.ProjectRefView;
import org.commonjava.maven.galley.maven.rel.ModelProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenModelProcessor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public EProjectDirectRelationships readRelationships(MavenPomView pomView, URI source, ModelProcessorConfig discoveryConfig) throws GalleyMavenException {
        boolean includeManagedDependencies = discoveryConfig.isIncludeManagedDependencies();
        boolean includeBuildSection = discoveryConfig.isIncludeBuildSection();
        boolean includeManagedPlugins = discoveryConfig.isIncludeManagedPlugins();
        this.logger.info("Reading relationships for: {}\n  (from: {})", pomView.getRef(), (Object)source);
        try {
            ProjectVersionRef projectRef = (ProjectVersionRef)pomView.getRef();
            EProjectDirectRelationships.Builder builder = new EProjectDirectRelationships.Builder(source, projectRef, new String[0]);
            this.addParentRelationship(source, builder, pomView, projectRef);
            this.addDependencyRelationships(source, builder, pomView, projectRef, includeManagedDependencies);
            if (includeBuildSection) {
                this.addExtensionUsages(source, builder, pomView, projectRef);
                this.addPluginUsages(source, builder, pomView, projectRef, includeManagedPlugins);
            }
            return builder.build();
        }
        catch (InvalidVersionSpecificationException e) {
            throw new GalleyMavenException("Failed to parse version for model: {}. Reason: {}", (Throwable)e, pomView, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new GalleyMavenException("Failed to parse relationships for model: {}. Reason: {}", (Throwable)e, pomView, e.getMessage());
        }
    }

    private void addExtensionUsages(URI source, EProjectDirectRelationships.Builder builder, MavenPomView pomView, ProjectVersionRef projectRef) throws GalleyMavenException {
        List<ExtensionView> extensions = null;
        try {
            extensions = pomView.getBuildExtensions();
        }
        catch (GalleyMavenException e) {
            this.logger.error(String.format("%s: Cannot retrieve build extensions: %s", pomView.getRef(), e.getMessage()), e);
        }
        catch (InvalidVersionSpecificationException e) {
            this.logger.error(String.format("%s: Cannot retrieve build extensions: %s", pomView.getRef(), e.getMessage()), e);
        }
        catch (InvalidRefException e) {
            this.logger.error(String.format("%s: Cannot retrieve build extensions: %s", pomView.getRef(), e.getMessage()), e);
        }
        if (extensions != null) {
            for (ExtensionView ext : extensions) {
                if (ext == null) continue;
                try {
                    ProjectVersionRef ref = ext.asProjectVersionRef();
                    ref.getVersionSpec();
                    builder.withExtensions(new SimpleExtensionRelationship(source, projectRef, ref, builder.getNextExtensionIndex(), ext.getOriginInfo().isInherited()));
                }
                catch (InvalidRefException | InvalidVersionSpecificationException | GalleyMavenException e) {
                    this.logger.error(String.format("%s: Build extension is invalid! Reason: %s. Skipping:\n\n%s\n\n", pomView.getRef(), e.getMessage(), ext.toXML()), e);
                }
            }
        }
    }

    private void addPluginUsages(URI source, EProjectDirectRelationships.Builder builder, MavenPomView pomView, ProjectVersionRef projectRef, boolean includeManagedPlugins) throws GalleyMavenException {
        this.addBuildPluginUsages(source, builder, pomView, projectRef, includeManagedPlugins);
        this.addReportPluginUsages(source, builder, pomView, projectRef);
        this.addSiteReportPluginUsages(source, builder, pomView, projectRef);
    }

    private void addSiteReportPluginUsages(URI source, EProjectDirectRelationships.Builder builder, MavenPomView pomView, ProjectVersionRef projectRef) throws GalleyMavenException {
        List<PluginView> plugins = null;
        try {
            plugins = pomView.getAllPluginsMatching("//plugin[artifactId/text()=\"maven-site-plugin\"]//reportPlugin");
        }
        catch (InvalidRefException e) {
            this.logger.error(String.format("%s: Cannot retrieve site-plugin nested reporting plugins: %s", pomView.getRef(), e.getMessage()), e);
        }
        catch (InvalidVersionSpecificationException e) {
            this.logger.error(String.format("%s: Cannot retrieve site-plugin nested reporting plugins: %s", pomView.getRef(), e.getMessage()), e);
        }
        catch (GalleyMavenException e) {
            this.logger.error(String.format("%s: Cannot retrieve site-plugin nested reporting plugins: %s", pomView.getRef(), e.getMessage()), e);
        }
        this.addPlugins(plugins, projectRef, builder, source, false);
    }

    public void addReportPluginUsages(URI source, EProjectDirectRelationships.Builder builder, MavenPomView pomView, ProjectVersionRef projectRef) throws GalleyMavenException {
        List<PluginView> plugins = null;
        try {
            plugins = pomView.getAllPluginsMatching("//reporting/plugins/plugin");
        }
        catch (GalleyMavenException e) {
            this.logger.error(String.format("%s: Cannot retrieve reporting plugins: %s", pomView.getRef(), e.getMessage()), e);
        }
        catch (InvalidVersionSpecificationException e) {
            this.logger.error(String.format("%s: Cannot retrieve reporting plugins: %s", pomView.getRef(), e.getMessage()), e);
        }
        catch (InvalidRefException e) {
            this.logger.error(String.format("%s: Cannot retrieve reporting plugins: %s", pomView.getRef(), e.getMessage()), e);
        }
        this.addPlugins(plugins, projectRef, builder, source, false);
    }

    public void addBuildPluginUsages(URI source, EProjectDirectRelationships.Builder builder, MavenPomView pomView, ProjectVersionRef projectRef, boolean includeManagedPlugins) throws GalleyMavenException {
        List<PluginView> plugins;
        if (includeManagedPlugins) {
            plugins = null;
            try {
                plugins = pomView.getAllManagedBuildPlugins();
            }
            catch (GalleyMavenException e) {
                this.logger.error(String.format("%s: Cannot retrieve managed plugins: %s", pomView.getRef(), e.getMessage()), e);
            }
            catch (InvalidVersionSpecificationException e) {
                this.logger.error(String.format("%s: Cannot retrieve managed plugins: %s", pomView.getRef(), e.getMessage()), e);
            }
            catch (InvalidRefException e) {
                this.logger.error(String.format("%s: Cannot retrieve managed plugins: %s", pomView.getRef(), e.getMessage()), e);
            }
            this.addPlugins(plugins, projectRef, builder, source, true);
        }
        plugins = null;
        try {
            plugins = pomView.getAllBuildPlugins();
        }
        catch (GalleyMavenException e) {
            this.logger.error(String.format("%s: Cannot retrieve build plugins: %s", pomView.getRef(), e.getMessage()), e);
        }
        catch (InvalidVersionSpecificationException e) {
            this.logger.error(String.format("%s: Cannot retrieve build plugins: %s", pomView.getRef(), e.getMessage()), e);
        }
        catch (InvalidRefException e) {
            this.logger.error(String.format("%s: Cannot retrieve build plugins: %s", pomView.getRef(), e.getMessage()), e);
        }
        this.addPlugins(plugins, projectRef, builder, source, false);
    }

    private void addPlugins(List<PluginView> plugins, ProjectVersionRef projectRef, EProjectDirectRelationships.Builder builder, URI source, boolean managed) {
        if (plugins != null) {
            for (PluginView plugin : plugins) {
                ProjectVersionRef pluginRef;
                try {
                    if (plugin.getVersion() == null) {
                        this.logger.error("%s: Cannot find a version for plugin: {}. Skipping.", (Object)projectRef, (Object)plugin.toXML());
                        continue;
                    }
                    pluginRef = plugin.asProjectVersionRef();
                    pluginRef.getVersionSpec();
                    String profileId = plugin.getProfileId();
                    URI location = RelationshipUtils.profileLocation(profileId);
                    boolean inherited = plugin.getOriginInfo().isInherited();
                    boolean mixin = plugin.getOriginInfo().isMixin();
                    builder.withPlugins(new SimplePluginRelationship(source, location, projectRef, pluginRef, builder.getNextPluginDependencyIndex(projectRef, managed, inherited), managed, inherited));
                }
                catch (GalleyMavenException e) {
                    this.logger.error(String.format("%s: plugin is invalid! Reason: %s. Skipping:\n\n%s\n\n", projectRef, e.getMessage(), plugin.toXML()), e);
                    continue;
                }
                catch (InvalidVersionSpecificationException e) {
                    this.logger.error(String.format("%s: plugin is invalid! Reason: %s. Skipping:\n\n%s\n\n", projectRef, e.getMessage(), plugin.toXML()), e);
                    continue;
                }
                catch (InvalidRefException e) {
                    this.logger.error(String.format("%s: plugin is invalid! Reason: %s. Skipping:\n\n%s\n\n", projectRef, e.getMessage(), plugin.toXML()), e);
                    continue;
                }
                List<PluginDependencyView> pluginDependencies = null;
                Set<PluginDependencyView> impliedPluginDependencies = null;
                try {
                    pluginDependencies = plugin.getLocalPluginDependencies();
                    impliedPluginDependencies = plugin.getImpliedPluginDependencies();
                }
                catch (GalleyMavenException e) {
                    this.logger.error(String.format("%s: Cannot retrieve plugin dependencies for: %s. Reason: %s", projectRef, pluginRef, e.getMessage()), e);
                }
                catch (InvalidVersionSpecificationException e) {
                    this.logger.error(String.format("%s: Cannot retrieve plugin dependencies for: %s. Reason: %s", projectRef, pluginRef, e.getMessage()), e);
                }
                catch (InvalidRefException e) {
                    this.logger.error(String.format("%s: Cannot retrieve plugin dependencies for: %s. Reason: %s", projectRef, pluginRef, e.getMessage()), e);
                }
                this.addPluginDependencies(pluginDependencies, plugin, pluginRef, projectRef, builder, source, managed);
                this.logger.debug("{}: Adding implied dependencies for: {}\n\n  {}", projectRef, pluginRef, impliedPluginDependencies == null ? "-NONE-" : new JoinString("\n  ", impliedPluginDependencies));
                this.addPluginDependencies(impliedPluginDependencies, plugin, pluginRef, projectRef, builder, source, managed);
            }
        }
    }

    private void addPluginDependencies(Collection<PluginDependencyView> pluginDependencies, PluginView plugin, ProjectVersionRef pluginRef, ProjectVersionRef projectRef, EProjectDirectRelationships.Builder builder, URI source, boolean managed) {
        if (pluginDependencies != null) {
            for (PluginDependencyView dep : pluginDependencies) {
                try {
                    ProjectVersionRef ref = dep.asProjectVersionRef();
                    String profileId = dep.getProfileId();
                    URI location = RelationshipUtils.profileLocation(profileId);
                    SimpleArtifactRef artifactRef = new SimpleArtifactRef(ref, dep.getType(), dep.getClassifier());
                    artifactRef.getVersionSpec();
                    boolean inherited = dep.getOriginInfo().isInherited();
                    boolean mixin = dep.getOriginInfo().isMixin();
                    builder.withPluginDependencies(new SimplePluginDependencyRelationship(source, location, projectRef, (ProjectRef)pluginRef, (ArtifactRef)artifactRef, builder.getNextPluginDependencyIndex(pluginRef, managed, inherited), managed, inherited));
                }
                catch (InvalidRefException e) {
                    this.logger.error(String.format("%s: plugin dependency is invalid in: %s! Reason: %s. Skipping:\n\n%s\n\n", projectRef, pluginRef, e.getMessage(), dep.toXML()), e);
                }
                catch (InvalidVersionSpecificationException e) {
                    this.logger.error(String.format("%s: plugin dependency is invalid in: %s! Reason: %s. Skipping:\n\n%s\n\n", projectRef, pluginRef, e.getMessage(), dep.toXML()), e);
                }
                catch (GalleyMavenException e) {
                    this.logger.error(String.format("%s: plugin dependency is invalid in: %s! Reason: %s. Skipping:\n\n%s\n\n", projectRef, pluginRef, e.getMessage(), dep.toXML()), e);
                }
            }
        }
    }

    protected void addDependencyRelationships(URI source, EProjectDirectRelationships.Builder builder, MavenPomView pomView, ProjectVersionRef projectRef, boolean includeManagedDependencies) {
        List<DependencyView> boms = null;
        try {
            boms = pomView.getAllBOMs();
        }
        catch (GalleyMavenException e) {
            this.logger.error(String.format("%s: Failed to retrieve BOM declarations: %s. Skipping", pomView.getRef(), e.getMessage()), e);
        }
        catch (InvalidVersionSpecificationException e) {
            this.logger.error(String.format("%s: Failed to retrieve BOM declarations: %s. Skipping", pomView.getRef(), e.getMessage()), e);
        }
        catch (InvalidRefException e) {
            this.logger.error(String.format("%s: Failed to retrieve BOM declarations: %s. Skipping", pomView.getRef(), e.getMessage()), e);
        }
        if (boms != null) {
            for (int i = 0; i < boms.size(); ++i) {
                DependencyView bomView = boms.get(i);
                try {
                    builder.withBoms(new SimpleBomRelationship(source, projectRef, bomView.asProjectVersionRef(), i, bomView.getOriginInfo().isInherited(), bomView.getOriginInfo().isMixin()));
                    continue;
                }
                catch (InvalidRefException e) {
                    this.logger.error(String.format("%s dependency is invalid! Reason: %s. Skipping:\n\n%s\n\n", pomView.getRef(), e.getMessage(), bomView.toXML()), e);
                    continue;
                }
                catch (InvalidVersionSpecificationException e) {
                    this.logger.error(String.format("%s dependency is invalid! Reason: %s. Skipping:\n\n%s\n\n", pomView.getRef(), e.getMessage(), bomView.toXML()), e);
                    continue;
                }
                catch (GalleyMavenException e) {
                    this.logger.error(String.format("%s dependency is invalid! Reason: %s. Skipping:\n\n%s\n\n", pomView.getRef(), e.getMessage(), bomView.toXML()), e);
                }
            }
        }
        if (includeManagedDependencies) {
            List<DependencyView> deps = null;
            try {
                deps = pomView.getAllManagedDependencies();
            }
            catch (GalleyMavenException e) {
                this.logger.error(String.format("%s: Failed to retrieve managed dependencies: %s. Skipping", pomView.getRef(), e.getMessage()), e);
            }
            catch (InvalidVersionSpecificationException e) {
                this.logger.error(String.format("%s: Failed to retrieve managed dependencies: %s. Skipping", pomView.getRef(), e.getMessage()), e);
            }
            catch (InvalidRefException e) {
                this.logger.error(String.format("%s: Failed to retrieve managed dependencies: %s. Skipping", pomView.getRef(), e.getMessage()), e);
            }
            this.addDependencies(deps, projectRef, builder, source, true);
        }
        List<DependencyView> deps = null;
        try {
            deps = pomView.getAllDirectDependencies();
        }
        catch (GalleyMavenException e) {
            this.logger.error(String.format("%s: Failed to retrieve direct dependencies: %s. Skipping", pomView.getRef(), e.getMessage()), e);
        }
        catch (InvalidVersionSpecificationException e) {
            this.logger.error(String.format("%s: Failed to retrieve direct dependencies: %s. Skipping", pomView.getRef(), e.getMessage()), e);
        }
        catch (InvalidRefException e) {
            this.logger.error(String.format("%s: Failed to retrieve direct dependencies: %s. Skipping", pomView.getRef(), e.getMessage()), e);
        }
        this.addDependencies(deps, projectRef, builder, source, false);
    }

    private void addDependencies(List<DependencyView> deps, ProjectVersionRef projectRef, EProjectDirectRelationships.Builder builder, URI source, boolean managed) {
        if (deps != null) {
            for (DependencyView dep : deps) {
                try {
                    ProjectRef[] excludes;
                    ProjectVersionRef ref = dep.asProjectVersionRef();
                    String profileId = dep.getProfileId();
                    URI location = RelationshipUtils.profileLocation(profileId);
                    SimpleArtifactRef artifactRef = new SimpleArtifactRef(ref, dep.getType(), dep.getClassifier());
                    artifactRef.getVersionSpec();
                    Set<ProjectRefView> exclusionsView = dep.getExclusions();
                    if (exclusionsView != null && !exclusionsView.isEmpty()) {
                        excludes = new ProjectRef[exclusionsView.size()];
                        int i = 0;
                        for (ProjectRefView exclusionView : exclusionsView) {
                            excludes[i] = exclusionView.asProjectRef();
                            ++i;
                        }
                    } else {
                        excludes = new ProjectRef[]{};
                    }
                    builder.withDependencies(new SimpleDependencyRelationship(source, location, projectRef, (ArtifactRef)artifactRef, dep.getScope(), builder.getNextDependencyIndex(managed), managed, dep.getOriginInfo().isInherited(), dep.isOptional(), excludes));
                }
                catch (InvalidRefException e) {
                    this.logger.error(String.format("%s: dependency is invalid! Reason: %s. Skipping:\n\n%s\n\n", projectRef, e.getMessage(), dep.toXML()), e);
                }
                catch (InvalidVersionSpecificationException e) {
                    this.logger.error(String.format("%s: dependency is invalid! Reason: %s. Skipping:\n\n%s\n\n", projectRef, e.getMessage(), dep.toXML()), e);
                }
                catch (GalleyMavenException e) {
                    this.logger.error(String.format("%s: dependency is invalid! Reason: %s. Skipping:\n\n%s\n\n", projectRef, e.getMessage(), dep.toXML()), e);
                }
            }
        }
    }

    protected void addParentRelationship(URI source, EProjectDirectRelationships.Builder builder, MavenPomView pomView, ProjectVersionRef projectRef) {
        try {
            ParentView parent = pomView.getParent();
            if (parent != null) {
                ProjectVersionRef ref = parent.asProjectVersionRef();
                ref.getVersionSpec();
                this.logger.info("Adding parent relationship for: {} to : {}", (Object)builder.getProjectRef(), (Object)ref);
                builder.withParent(new SimpleParentRelationship(source, builder.getProjectRef(), ref));
            } else {
                this.logger.info("Adding self-referential parent relationship for: {} to signify project has no parent, but is parsable.", (Object)builder.getProjectRef());
                builder.withParent(new SimpleParentRelationship(builder.getProjectRef()));
            }
        }
        catch (GalleyMavenException e) {
            this.logger.error(String.format("%s: Parent reference is invalid! Reason: %s. Skipping.", projectRef, e.getMessage()), e);
        }
        catch (InvalidVersionSpecificationException e) {
            this.logger.error(String.format("%s: Parent reference is invalid! Reason: %s. Skipping.", projectRef, e.getMessage()), e);
        }
        catch (InvalidRefException e) {
            this.logger.error(String.format("%s: Parent reference is invalid! Reason: %s. Skipping.", projectRef, e.getMessage()), e);
        }
    }
}

