/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.maven.ArtifactManager;
import org.commonjava.maven.galley.maven.GalleyMavenException;
import org.commonjava.maven.galley.maven.model.view.DependencyView;
import org.commonjava.maven.galley.maven.model.view.DocRef;
import org.commonjava.maven.galley.maven.model.view.MavenPomView;
import org.commonjava.maven.galley.maven.model.view.MavenXmlMixin;
import org.commonjava.maven.galley.maven.model.view.XPathManager;
import org.commonjava.maven.galley.maven.parse.AbstractMavenXmlReader;
import org.commonjava.maven.galley.maven.parse.XMLInfrastructure;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginDefaults;
import org.commonjava.maven.galley.maven.spi.defaults.MavenPluginImplications;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.spi.transport.LocationExpander;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@ApplicationScoped
public class MavenPomReader
extends AbstractMavenXmlReader<ProjectVersionRef> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private ArtifactManager artifacts;
    @Inject
    private MavenPluginDefaults pluginDefaults;
    @Inject
    private MavenPluginImplications pluginImplications;
    @Inject
    private XPathManager xpath;

    protected MavenPomReader() {
    }

    public MavenPomReader(XMLInfrastructure xml, LocationExpander locationExpander, ArtifactManager artifactManager, XPathManager xpath, MavenPluginDefaults pluginDefaults, MavenPluginImplications pluginImplications) {
        super(xml, locationExpander);
        this.artifacts = artifactManager;
        this.xpath = xpath;
        this.pluginDefaults = pluginDefaults;
        this.pluginImplications = pluginImplications;
    }

    public MavenPomView read(ProjectVersionRef ref, Transfer pom, List<? extends Location> locations, String ... activeProfileLocations) throws GalleyMavenException {
        return this.read(ref, pom, locations, new EventMetadata(), activeProfileLocations);
    }

    public MavenPomView read(ProjectVersionRef ref, Transfer pom, List<? extends Location> locations, EventMetadata eventMetadata, String ... activeProfileLocations) throws GalleyMavenException {
        DocRef<ProjectVersionRef> dr;
        ArrayList<DocRef<ProjectVersionRef>> stack = new ArrayList<DocRef<ProjectVersionRef>>();
        try {
            dr = this.getDocRef(ref, pom, false, eventMetadata);
        }
        catch (TransferException e) {
            throw new GalleyMavenException("Failed to retrieve POM for: {}, {} levels deep in ancestry stack of: {}. Reason: {}", (Throwable)e, ref, stack.size(), ref, e.getMessage());
        }
        stack.add(dr);
        ProjectVersionRef next = this.xml.getParentRef(dr.getDoc());
        while (next != null) {
            try {
                dr = this.getDocRef(next, locations, false, eventMetadata);
            }
            catch (TransferException e) {
                throw new GalleyMavenException("Failed to retrieve POM for: {}, {} levels deep in ancestry stack of: {}. Reason: {}", (Throwable)e, next, stack.size(), ref, e.getMessage());
            }
            if (dr == null) {
                throw new GalleyMavenException("Cannot resolve {}, {} levels dep in the ancestry stack of: {}", next, stack.size(), ref);
            }
            stack.add(dr);
            next = this.xml.getParentRef(dr.getDoc());
        }
        MavenPomView view = new MavenPomView(ref, stack, this.xpath, this.pluginDefaults, this.pluginImplications, this.xml, activeProfileLocations);
        this.assembleImportedInformation(view, locations);
        this.logStructure(view);
        return view;
    }

    public void logStructure(final MavenPomView view) {
        this.logger.debug("{}", new Object(){

            public String toString() {
                return MavenPomReader.this.printStructure(view);
            }
        });
    }

    private String printStructure(MavenPomView view) {
        StringBuilder sb = new StringBuilder();
        List stack = view.getDocRefStack();
        List mixins = view.getMixins();
        sb.append("\n\n").append(view.getRef()).append(" consists of:\n  ");
        int i = 0;
        for (DocRef docRef : stack) {
            sb.append("\n  D").append(i++).append(docRef);
        }
        sb.append("\n\n");
        if (mixins != null && !mixins.isEmpty()) {
            sb.append(mixins.size()).append(" Mix-ins for ").append(view.getRef()).append(":\n\n");
            i = 0;
            for (MavenXmlMixin mavenXmlMixin : mixins) {
                sb.append('M').append(i++).append(mavenXmlMixin).append("\n    ");
                sb.append(this.printStructure((MavenPomView)mavenXmlMixin.getMixin()));
            }
            sb.append("\n\n");
        }
        return sb.toString();
    }

    private DocRef<ProjectVersionRef> getDocRef(ProjectVersionRef ref, List<? extends Location> locations, boolean cache, EventMetadata eventMetadata) throws TransferException, GalleyMavenException {
        DocRef<ProjectVersionRef> dr = this.getFirstCached(ref, locations);
        if (dr == null) {
            Transfer transfer = this.artifacts.retrieveFirst(locations, ref.asPomArtifact(), eventMetadata);
            if (transfer == null) {
                return null;
            }
            Document doc = this.xml.parse(transfer, new EventMetadata());
            dr = new DocRef<ProjectVersionRef>(ref, transfer.getLocation().toString(), doc);
            if (cache) {
                this.cache(dr);
            }
        }
        return dr;
    }

    private DocRef<ProjectVersionRef> getDocRef(ProjectVersionRef ref, Transfer pom, boolean cache, EventMetadata eventMetadata) throws GalleyMavenException, TransferException {
        DocRef<ProjectVersionRef> dr = this.getFirstCached(ref, Collections.singletonList(pom.getLocation()));
        if (dr == null) {
            Document doc = this.xml.parse(pom, eventMetadata);
            dr = new DocRef<ProjectVersionRef>(ref, pom.getLocation(), doc);
        }
        if (cache) {
            this.cache(dr);
        }
        return dr;
    }

    public MavenPomView readLocalPom(ProjectVersionRef ref, Transfer transfer, String ... activeProfileIds) throws GalleyMavenException {
        return this.readLocalPom(ref, transfer, false, activeProfileIds);
    }

    public MavenPomView readLocalPom(ProjectVersionRef ref, Transfer transfer, EventMetadata eventMetadata, String ... activeProfileIds) throws GalleyMavenException {
        return this.readLocalPom(ref, transfer, false, eventMetadata, activeProfileIds);
    }

    public MavenPomView readLocalPom(ProjectVersionRef ref, Transfer transfer, boolean cache, String ... activeProfileIds) throws GalleyMavenException {
        return this.readLocalPom(ref, transfer, cache, new EventMetadata(), activeProfileIds);
    }

    public MavenPomView readLocalPom(ProjectVersionRef ref, Transfer transfer, boolean cache, EventMetadata eventMetadata, String ... activeProfileIds) throws GalleyMavenException {
        DocRef<ProjectVersionRef> dr;
        try {
            dr = this.getDocRef(ref, transfer, cache, eventMetadata);
        }
        catch (TransferException e) {
            throw new GalleyMavenException("Failed to parse POM for: {}. Reason: {}", (Throwable)e, ref, e.getMessage());
        }
        MavenPomView view = new MavenPomView(ref, Collections.singletonList(dr), this.xpath, this.pluginDefaults, this.pluginImplications, this.xml, activeProfileIds);
        this.logStructure(view);
        return view;
    }

    public MavenPomView read(ProjectVersionRef ref, List<? extends Location> locations, String ... activeProfileIds) throws GalleyMavenException {
        return this.read(ref, locations, false, activeProfileIds);
    }

    public MavenPomView read(ProjectVersionRef ref, List<? extends Location> locations, EventMetadata eventMetadata, String ... activeProfileIds) throws GalleyMavenException {
        return this.read(ref, locations, false, eventMetadata, activeProfileIds);
    }

    public MavenPomView read(ProjectVersionRef ref, List<? extends Location> locations, boolean cache, String ... activeProfileIds) throws GalleyMavenException {
        return this.read(ref, locations, cache, new EventMetadata(), activeProfileIds);
    }

    public MavenPomView read(ProjectVersionRef ref, List<? extends Location> locations, boolean cache, EventMetadata eventMetadata, String ... activeProfileIds) throws GalleyMavenException {
        DocRef<ProjectVersionRef> dr;
        ArrayList<DocRef<ProjectVersionRef>> stack = new ArrayList<DocRef<ProjectVersionRef>>();
        ProjectVersionRef next = ref;
        do {
            try {
                dr = this.getDocRef(next, locations, cache, eventMetadata);
            }
            catch (TransferException e) {
                throw new GalleyMavenException("Failed to retrieve POM for: {}, {} levels deep in ancestry stack of: {}. Reason: {}", (Throwable)e, next, stack.size(), ref, e.getMessage());
            }
            if (dr == null) {
                throw new GalleyMavenException("Cannot resolve {}, {} levels dep in the ancestry stack of: {}", next, stack.size(), ref);
            }
            stack.add(dr);
        } while ((next = this.xml.getParentRef(dr.getDoc())) != null);
        MavenPomView view = new MavenPomView(ref, stack, this.xpath, this.pluginDefaults, this.pluginImplications, this.xml, activeProfileIds);
        this.assembleImportedInformation(view, locations);
        this.logStructure(view);
        return view;
    }

    private void assembleImportedInformation(MavenPomView view, List<? extends Location> locations) throws GalleyMavenException {
        List<DependencyView> md = view.getAllBOMs();
        for (DependencyView dv : md) {
            ProjectVersionRef ref = dv.asProjectVersionRef();
            this.logger.debug("Found BOM: {} for: {}", (Object)ref, view.getRef());
            MavenPomView imp = this.read(ref, locations, true, new String[0]);
            view.addMixin(new MavenXmlMixin<ProjectVersionRef>(imp, MavenXmlMixin.DEPENDENCY_MIXIN));
        }
    }
}

