/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.internal.xfer;

import java.util.concurrent.TimeoutException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.TransferTimeoutException;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.ListingResult;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.spi.nfc.NotFoundCache;
import org.commonjava.maven.galley.spi.transport.ListingJob;
import org.commonjava.maven.galley.spi.transport.Transport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ListingHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    private NotFoundCache nfc;

    public ListingHandler() {
    }

    public ListingHandler(NotFoundCache nfc) {
        this.nfc = nfc;
    }

    public ListingResult list(ConcreteResource resource, Transfer target, int timeoutSeconds, Transport transport, boolean suppressFailures) throws TransferException {
        block12: {
            if (this.nfc.isMissing(resource)) {
                this.logger.debug("NFC: Already marked as missing: {}", (Object)resource);
                return null;
            }
            if (transport == null) {
                this.logger.warn("No transports available to handle: {} with location type: {}", (Object)resource, (Object)resource.getLocation().getClass().getSimpleName());
                return null;
            }
            this.logger.debug("LIST {}", (Object)resource);
            ListingJob job = transport.createListingJob(resource, target, timeoutSeconds);
            try {
                ListingResult result = (ListingResult)job.call();
                if (job.getError() != null) {
                    this.logger.debug("NFC: Download error. Marking as missing: {}", (Object)resource);
                    this.nfc.addMissing(resource);
                    if (!suppressFailures) {
                        throw job.getError();
                    }
                } else if (result == null) {
                    this.logger.debug("NFC: Download did not complete. Marking as missing: {}", (Object)resource);
                    this.nfc.addMissing(resource);
                }
                return result;
            }
            catch (TimeoutException e) {
                if (!suppressFailures) {
                    throw new TransferTimeoutException(target, "Timed-out download: {}. Reason: {}", (Throwable)e, resource, e.getMessage());
                }
            }
            catch (TransferException e) {
                if (!suppressFailures) {
                    throw e;
                }
            }
            catch (Exception e) {
                if (suppressFailures) break block12;
                throw new TransferException("Failed listing: {}. Reason: {}", (Throwable)e, resource, e.getMessage());
            }
        }
        return null;
    }
}

