/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley;

import java.net.MalformedURLException;
import org.commonjava.maven.galley.TransferLocationException;
import org.commonjava.maven.galley.model.ConcreteResource;
import org.commonjava.maven.galley.model.Location;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.util.UrlUtils;

public class TransferTimeoutException
extends TransferLocationException {
    private static final long serialVersionUID = 1L;
    private final String url;

    public TransferTimeoutException(Location location, String url, String format, Object ... params) {
        super(location, format, params);
        this.url = url;
    }

    public TransferTimeoutException(Location location, String url, String format, Throwable error, Object ... params) {
        super(location, format, error, params);
        this.url = url;
    }

    public TransferTimeoutException(Transfer target, String format, Object ... params) {
        super(target.getLocation(), format, params);
        this.url = this.composeUrl(target.getResource());
    }

    public TransferTimeoutException(Transfer target, String format, Throwable error, Object ... params) {
        super(target.getLocation(), format, error, params);
        this.url = this.composeUrl(target.getResource());
    }

    public TransferTimeoutException(ConcreteResource resource, String format, Object ... params) {
        super(resource.getLocation(), format, params);
        this.url = this.composeUrl(resource);
    }

    @Override
    public String getMessage() {
        return super.getMessage() + "\nTimed out URL: " + this.getUrl();
    }

    public String getUrl() {
        return this.url;
    }

    private String composeUrl(ConcreteResource resource) {
        String u;
        try {
            u = UrlUtils.buildUrl(resource);
        }
        catch (MalformedURLException e) {
            u = resource.getLocation().getUri() + resource.getPath();
        }
        return u;
    }
}

