/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleArtifactRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.DependencyState;
import org.commonjava.maven.ext.core.state.RelocationState;
import org.commonjava.maven.ext.core.util.IdUtils;
import org.commonjava.maven.ext.core.util.WildcardMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="relocations-manipulator")
@Singleton
public class RelocationManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ManipulationSession session;

    @Override
    public void init(ManipulationSession session) throws ManipulationException {
        this.session = session;
        session.setState(new RelocationState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        RelocationState state = this.session.getState(RelocationState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            Model model;
            if (!this.apply(project, model = project.getModel())) continue;
            changed.add(project);
        }
        return changed;
    }

    private boolean apply(Project project, Model model) throws ManipulationException {
        boolean result = false;
        RelocationState state = this.session.getState(RelocationState.class);
        WildcardMap<ProjectVersionRef> relocations = state.getDependencyRelocations();
        this.logger.debug("Applying relocation changes to: " + IdUtils.ga(project));
        DependencyManagement dependencyManagement = model.getDependencyManagement();
        if (dependencyManagement != null) {
            result = this.updateDependencies(relocations, project.getResolvedManagedDependencies(this.session));
        }
        result |= this.updateDependencies(relocations, project.getAllResolvedDependencies(this.session));
        for (Profile profile : ProfileUtils.getProfiles(this.session, model)) {
            dependencyManagement = profile.getDependencyManagement();
            if (dependencyManagement != null) {
                result |= this.updateDependencies(relocations, project.getResolvedProfileManagedDependencies(this.session).get(profile));
            }
            result |= this.updateDependencies(relocations, project.getAllResolvedProfileDependencies(this.session).get(profile));
        }
        return result;
    }

    private boolean updateDependencies(WildcardMap<ProjectVersionRef> relocations, Map<ArtifactRef, Dependency> dependencies) {
        boolean result = false;
        HashMap<SimpleArtifactRef, Dependency> postFixUp = new HashMap<SimpleArtifactRef, Dependency>();
        for (int i = 0; i < relocations.size(); ++i) {
            Iterator<ArtifactRef> it = dependencies.keySet().iterator();
            while (it.hasNext()) {
                ArtifactRef pvr = it.next();
                if (!relocations.containsKey(pvr.asProjectRef())) continue;
                ProjectVersionRef relocation = relocations.get(pvr.asProjectRef());
                this.updateDependencyExclusion(pvr, relocation);
                this.logger.info("Replacing groupId {} by {} and artifactId {} with {}", dependencies.get(pvr).getGroupId(), relocation.getGroupId(), dependencies.get(pvr).getArtifactId(), relocation.getArtifactId());
                if (!relocation.getArtifactId().equals("*")) {
                    dependencies.get(pvr).setArtifactId(relocation.getArtifactId());
                }
                dependencies.get(pvr).setGroupId(relocation.getGroupId());
                postFixUp.put(SimpleArtifactRef.parse(dependencies.get(pvr).getManagementKey()), dependencies.get(pvr));
                it.remove();
                result = true;
            }
            dependencies.putAll(postFixUp);
            postFixUp.clear();
        }
        return result;
    }

    private void updateDependencyExclusion(ProjectVersionRef depPvr, ProjectVersionRef relocation) {
        DependencyState state = this.session.getState(DependencyState.class);
        if (relocation.getVersionString().equals("*")) {
            this.logger.debug("No version alignment to perform for relocations");
        } else {
            String artifact = depPvr.getArtifactId();
            if (!relocation.getArtifactId().equals("*")) {
                artifact = relocation.getArtifactId();
            }
            this.logger.debug("Adding dependencyOverride {} & {}", (Object)(relocation.getGroupId() + ':' + artifact + "@*"), (Object)relocation.getVersionString());
            state.updateExclusions(relocation.getGroupId() + ':' + artifact + "@*", relocation.getVersionString());
        }
    }

    @Override
    public int getExecutionIndex() {
        return 15;
    }
}

