/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.atlas.ident.version.part;

import java.io.Serializable;
import java.util.Date;
import org.commonjava.maven.atlas.ident.util.SnapshotUtils;
import org.commonjava.maven.atlas.ident.version.part.StringPart;
import org.commonjava.maven.atlas.ident.version.part.VersionPart;

public class SnapshotPart
extends VersionPart
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Date timestamp;
    private final Integer buildNumber;
    private final String literal;

    public SnapshotPart(Date timestamp, int buildNumber, String literal) {
        this.timestamp = timestamp;
        this.buildNumber = buildNumber;
        this.literal = literal;
    }

    public SnapshotPart(String literal) {
        if (SnapshotUtils.isRemoteSnapshotVersionPart(literal)) {
            SnapshotPart sp = SnapshotUtils.parseRemoteSnapshotVersionPart(literal);
            this.timestamp = sp.timestamp;
            this.buildNumber = sp.buildNumber;
        } else {
            this.timestamp = null;
            this.buildNumber = null;
        }
        this.literal = literal;
    }

    public String getLiteral() {
        return this.literal;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public boolean isLocalSnapshot() {
        return this.timestamp == null;
    }

    public boolean isRemoteSnapshot() {
        return this.timestamp != null;
    }

    public String toString() {
        return "SNAP[" + (this.timestamp == null ? "local" : "remote;" + this.renderStandard()) + "]";
    }

    @Override
    public String renderStandard() {
        return this.literal;
    }

    public String getValue() {
        return this.renderStandard();
    }

    @Override
    public int compareTo(VersionPart o) {
        if (o instanceof SnapshotPart) {
            SnapshotPart oSnap = (SnapshotPart)o;
            if (!this.isLocalSnapshot() && !oSnap.isLocalSnapshot()) {
                int comp = this.getTimestamp().compareTo(oSnap.getTimestamp());
                if (comp == 0) {
                    return this.getBuildNumber() - oSnap.getBuildNumber();
                }
                return comp;
            }
            if (this.isLocalSnapshot() && !oSnap.isLocalSnapshot()) {
                return 1;
            }
            if (!this.isLocalSnapshot() && oSnap.isLocalSnapshot()) {
                return -1;
            }
            return 0;
        }
        if (o instanceof StringPart) {
            return -1 * o.compareTo(this);
        }
        return -1;
    }

    public boolean isPaddingPrepended() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.buildNumber == null ? 0 : this.buildNumber.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SnapshotPart other = (SnapshotPart)obj;
        if (this.buildNumber == null ? other.buildNumber != null : !this.buildNumber.equals(other.buildNumber)) {
            return false;
        }
        return !(this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp));
    }
}

