/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

@Mojo(name="use-next-releases", requiresProject=true, requiresDirectInvocation=true, threadSafe=true)
public class UseNextReleasesMojo
extends AbstractVersionsDependencyUpdaterMojo {
    public final Pattern matchSnapshotRegex = Pattern.compile("^(.+)-((SNAPSHOT)|(\\d{8}\\.\\d{6}-\\d+))$");

    @Override
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, ArtifactMetadataRetrievalException {
        if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
            this.useNextReleases(pom, this.getProject().getDependencyManagement().getDependencies());
        }
        if (this.getProject().getDependencies() != null && this.isProcessingDependencies()) {
            this.useNextReleases(pom, this.getProject().getDependencies());
        }
    }

    private void useNextReleases(ModifiedPomXMLEventReader pom, Collection<Dependency> dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        for (Dependency dep : dependencies) {
            ArtifactVersions versions;
            ArtifactVersion[] newer;
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info("Ignoring reactor dependency: " + this.toString(dep));
                continue;
            }
            String version = dep.getVersion();
            Matcher versionMatcher = this.matchSnapshotRegex.matcher(version);
            if (versionMatcher.matches()) continue;
            this.getLog().debug("Looking for newer versions of " + this.toString(dep));
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact) || (newer = (versions = this.getHelper().lookupArtifactVersions(artifact, false)).getNewerVersions(version, false)).length <= 0) continue;
            String newVersion = newer[0].toString();
            if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, newVersion, this.getProject().getModel())) continue;
            this.getLog().info("Updated " + this.toString(dep) + " to version " + newVersion);
        }
    }
}

