/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security.config;

import org.jboss.security.authorization.config.AuthorizationModuleEntry;

//$Id: AuthorizationInfo.java 86074 2009-03-18 20:08:08Z anil.saldhana@jboss.com $

/**
 *  Holder for Authorization configuration
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @since  Jun 9, 2006 
 *  @version $Revision: 86074 $
 */
public class AuthorizationInfo extends BaseSecurityInfo<AuthorizationModuleEntry>
{  
   public AuthorizationInfo(String name)
   {
      super(name); 
   }  
   
   public AuthorizationModuleEntry[] getAuthorizationModuleEntry()
   {
      SecurityManager sm = System.getSecurityManager();
      if( sm != null )
         sm.checkPermission(GET_CONFIG_ENTRY_PERM); 
      AuthorizationModuleEntry[] entries = new AuthorizationModuleEntry[moduleEntries.size()];
      moduleEntries.toArray(entries);
      return entries;
   }

   @Override
   protected BaseSecurityInfo<AuthorizationModuleEntry> create(String name)
   {
      return new AuthorizationInfo(name);
   } 
}
