/*
  * JBoss, Home of Professional Open Source
  * Copyright 2007, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security.identity.plugins;

import java.util.ArrayList;
import java.util.List;

import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.RoleType;

//$Id$

/**
 *  Simple Role Group
 *  @author Anil.Saldhana@redhat.com
 *  @since  Nov 16, 2007 
 *  @version $Revision$
 */
public class SimpleRoleGroup extends SimpleRole implements RoleGroup
{
   private static final long serialVersionUID = 1L;
   private ArrayList<Role> roles;

   public SimpleRoleGroup(String roleName)
   {
      super(roleName); 
   }

   public SimpleRoleGroup(String roleName, List<Role> roles)
   {
      super(roleName); 
      if(this.roles == null)
         this.roles = new ArrayList<Role>();
      this.roles.addAll(roles);
   }
   
   @Override
   public RoleType getType()
   {
      return RoleType.group;
   }

   public List<Role> getRoles()
   {
      return roles;
   }
   
   public synchronized Object clone() throws CloneNotSupportedException  
   {  
      SimpleRoleGroup clone = (SimpleRoleGroup) super.clone();  
      if(clone != null) 
        clone.roles = (ArrayList<Role>)this.roles.clone();   
      return clone;  
   } 
}