/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.config;

import org.jboss.logging.Logger;
import org.jboss.security.audit.config.AuditProviderEntry;
import org.jboss.security.auth.login.LoginConfigObjectModelFactory;
import org.jboss.security.auth.login.ModuleOption;
import org.jboss.security.authorization.config.AuthorizationConfigEntryHolder;
import org.jboss.security.authorization.config.AuthorizationModuleEntry;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.AuditInfo;
import org.jboss.security.config.AuthorizationInfo;
import org.jboss.security.config.ControlFlag;
import org.jboss.security.config.IdentityTrustInfo;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.identitytrust.config.IdentityTrustModuleEntry;
import org.jboss.security.mapping.config.MappingModuleEntry;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class SecurityConfigObjectModelFactory
extends LoginConfigObjectModelFactory {
    private static Logger log = Logger.getLogger(SecurityConfigObjectModelFactory.class);
    private boolean trace = log.isTraceEnabled();

    public Object newChild(ApplicationPolicy aPolicy, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        Object child = super.newChild(aPolicy, navigator, namespaceUri, localName, attrs);
        if (child == null && "authorization".equals(localName)) {
            child = new AuthorizationInfo(aPolicy.getName());
        } else if (child == null && "rolemapping".equals(localName)) {
            MappingInfo mi = new MappingInfo();
            mi.setName(aPolicy.getName());
            child = mi;
        } else if (child == null && "audit".equals(localName)) {
            AuditInfo ai = new AuditInfo(aPolicy.getName());
            child = ai;
        } else if (child == null && "identity-trust".equals(localName)) {
            IdentityTrustInfo ai = new IdentityTrustInfo(aPolicy.getName());
            child = ai;
        }
        return child;
    }

    public Object newChild(AuthorizationInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        AuthorizationModuleEntry child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AuthorizationInfo, localName: " + localName));
        }
        if ("policy-module".equals(localName)) {
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties((String)code.trim());
            String flag = attrs.getValue("flag");
            if (flag != null) {
                flag = StringPropertyReplacer.replaceProperties((String)flag.trim());
            }
            flag = flag == null ? "REQUIRED" : flag.toUpperCase();
            AuthorizationModuleEntry entry = new AuthorizationModuleEntry(code);
            if ("REQUIRED".equals(flag)) {
                entry.setControlFlag(ControlFlag.REQUIRED);
            } else if ("REQUISITE".equals(flag)) {
                entry.setControlFlag(ControlFlag.REQUISITE);
            } else if ("SUFFICIENT".equals(flag)) {
                entry.setControlFlag(ControlFlag.SUFFICIENT);
            } else {
                entry.setControlFlag(ControlFlag.OPTIONAL);
            }
            child = entry;
            if (this.trace) {
                log.trace((Object)("newChild.AuthorizationInfo, policy-module code: " + code));
            }
        }
        return child;
    }

    public Object newChild(AuthorizationModuleEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AppConfigurationEntryHolder, localName: " + localName));
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace((Object)("newChild.AuthModuleEntry, module-option name: " + name));
            }
        }
        return child;
    }

    public void addChild(ApplicationPolicy aPolicy, AuthorizationInfo authInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aPolicy.setAuthorizationInfo(authInfo);
        if (this.trace) {
            log.trace((Object)("addChild.ApplicationPolicy, name: " + aPolicy.getName()));
        }
    }

    public void addChild(AuthorizationInfo authInfo, AuthorizationConfigEntryHolder entryInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        AuthorizationModuleEntry entry = entryInfo.getEntry();
        authInfo.add(entry);
        if (this.trace) {
            log.trace((Object)("addChild.AuthorizationInfo, name: " + entry.getPolicyModuleName()));
        }
    }

    public void addChild(AuthorizationConfigEntryHolder entryInfo, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entryInfo.addOption(option);
        if (this.trace) {
            log.trace((Object)("addChild.AuthorizationConfigEntryHolder, name: " + option.getName()));
        }
    }

    public void addChild(AuthorizationInfo authInfo, AuthorizationModuleEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName) {
        authInfo.add(entry);
    }

    public void addChild(AuthorizationModuleEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entry.add(option);
        if (this.trace) {
            log.trace((Object)("addChild.AuthorizationModuleEntry, name: " + option.getName()));
        }
    }

    public Object newChild(MappingInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        MappingModuleEntry child = null;
        if (this.trace) {
            log.trace((Object)("newChild.RoleMappingInfo, localName: " + localName));
        }
        if ("mapping-module".equals(localName)) {
            MappingModuleEntry entry;
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties((String)code.trim());
            child = entry = new MappingModuleEntry(code);
            if (this.trace) {
                log.trace((Object)("newChild.RoleMappingInfo, mapping-module code: " + code));
            }
        }
        return child;
    }

    public Object newChild(MappingModuleEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace((Object)("newChild.MappingModuleEntry, localName: " + localName));
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace((Object)("newChild.MappingModuleEntry, module-option name: " + name));
            }
        }
        return child;
    }

    public void addChild(ApplicationPolicy aPolicy, MappingInfo authInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aPolicy.setRoleMappingInfo(authInfo);
        if (this.trace) {
            log.trace((Object)("addChild.ApplicationPolicy, name: " + aPolicy.getName()));
        }
    }

    public void addChild(MappingModuleEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entry.add(option);
        if (this.trace) {
            log.trace((Object)("addChild.MappingModuleEntry, name: " + option.getName()));
        }
    }

    public void addChild(MappingInfo authInfo, MappingModuleEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName) {
        authInfo.add(entry);
    }

    public Object newChild(AuditInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        AuditProviderEntry child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AuditInfo, localName: " + localName));
        }
        if ("provider-module".equals(localName)) {
            AuditProviderEntry entry;
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties((String)code.trim());
            child = entry = new AuditProviderEntry(code);
            if (this.trace) {
                log.trace((Object)("newChild.AuditInfo, provider-module code: " + code));
            }
        }
        return child;
    }

    public Object newChild(AuditProviderEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace((Object)("newChild.AuditProviderEntry, localName: " + localName));
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace((Object)("newChild.AuditProviderEntry, module-option name: " + name));
            }
        }
        return child;
    }

    public void addChild(ApplicationPolicy aPolicy, AuditInfo auditInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aPolicy.setAuditInfo(auditInfo);
        if (this.trace) {
            log.trace((Object)("addChild.ApplicationPolicy, name: " + aPolicy.getName()));
        }
    }

    public void addChild(AuditProviderEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entry.add(option);
        if (this.trace) {
            log.trace((Object)("addChild.MappingModuleEntry, name: " + option.getName()));
        }
    }

    public void addChild(AuditInfo auditInfo, AuditProviderEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName) {
        auditInfo.add(entry);
    }

    public Object newChild(IdentityTrustInfo info, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        IdentityTrustModuleEntry child = null;
        if (this.trace) {
            log.trace((Object)("newChild.IdentityTrustInfo, localName: " + localName));
        }
        if ("trust-module".equals(localName)) {
            String code = attrs.getValue("code");
            code = StringPropertyReplacer.replaceProperties((String)code.trim());
            String flag = attrs.getValue("flag");
            if (flag != null) {
                flag = StringPropertyReplacer.replaceProperties((String)flag.trim());
            }
            flag = flag == null ? "REQUIRED" : flag.toUpperCase();
            IdentityTrustModuleEntry entry = new IdentityTrustModuleEntry(code);
            if ("REQUIRED".equals(flag)) {
                entry.setControlFlag(ControlFlag.REQUIRED);
            } else if ("REQUISITE".equals(flag)) {
                entry.setControlFlag(ControlFlag.REQUISITE);
            } else if ("SUFFICIENT".equals(flag)) {
                entry.setControlFlag(ControlFlag.SUFFICIENT);
            } else {
                entry.setControlFlag(ControlFlag.OPTIONAL);
            }
            child = entry;
            if (this.trace) {
                log.trace((Object)("newChild.IdentityTrustInfo, trust-module code: " + code));
            }
        }
        return child;
    }

    public Object newChild(IdentityTrustModuleEntry entry, UnmarshallingContext navigator, String namespaceUri, String localName, Attributes attrs) {
        ModuleOption child = null;
        if (this.trace) {
            log.trace((Object)("newChild.trustProviderEntry, localName: " + localName));
        }
        if ("module-option".equals(localName)) {
            String name = attrs.getValue("name");
            child = new ModuleOption(name);
            if (this.trace) {
                log.trace((Object)("newChild.trustProviderEntry, module-option name: " + name));
            }
        }
        return child;
    }

    public void addChild(ApplicationPolicy aPolicy, IdentityTrustInfo auditInfo, UnmarshallingContext navigator, String namespaceURI, String localName) {
        aPolicy.setIdentityTrustInfo(auditInfo);
        if (this.trace) {
            log.trace((Object)("addChild.ApplicationPolicy, name: " + aPolicy.getName()));
        }
    }

    public void addChild(IdentityTrustModuleEntry entry, ModuleOption option, UnmarshallingContext navigator, String namespaceURI, String localName) {
        entry.add(option);
        if (this.trace) {
            log.trace((Object)("addChild.MappingModuleEntry, name: " + option.getName()));
        }
    }

    public void addChild(IdentityTrustInfo auditInfo, IdentityTrustModuleEntry entry, UnmarshallingContext navigator, String namespaceURI, String localName) {
        auditInfo.add(entry);
    }
}

