/*
  * JBoss, Home of Professional Open Source
  * Copyright 2007, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security.identity.plugins;

import java.lang.reflect.Constructor;
import java.security.Principal;
import java.security.acl.Group;

//$Id$

/**
 *  Factory to create customized principal and group
 *  instances
 *  @author Anil.Saldhana@redhat.com
 *  @since  Nov 18, 2007 
 *  @version $Revision$
 */
public class IdentityFactory
{
   public static final String PRINCIPAL_CLASS = "org.jboss.security.SimplePrincipal";
   
   public static final String GROUP_CLASS = "org.jboss.security.SimpleGroup";

   public static Principal createPrincipal(String name) throws Exception
   {
     Class<Principal> clazz = SecurityActions.getClass(PRINCIPAL_CLASS);
     Constructor<Principal> ctr = clazz.getConstructor(new Class[]{String.class});
     return (Principal) ctr.newInstance(new Object[]{name});
   }
   
   public static Group createGroup(String name) throws Exception
   {
      Class<Group> clazz = SecurityActions.getClass(GROUP_CLASS);
      Constructor<Group> ctr = clazz.getConstructor(new Class[]{String.class});
      return (Group) ctr.newInstance(new Object[]{name});
   }
}