/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.security.acl.ACL;
import org.jboss.security.acl.ACLEntry;
import org.jboss.security.acl.ACLImpl;
import org.jboss.security.acl.config.ACLDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACLConfiguration {
    private final Map<String, ACLDefinition> definitions = new HashMap<String, ACLDefinition>();

    public void addDefinition(Object definition) {
        if (definition instanceof ACLDefinition) {
            ACLDefinition aclDefinition = (ACLDefinition)definition;
            this.definitions.put(aclDefinition.getResource(), aclDefinition);
        }
    }

    public Collection<ACL> getConfiguredACLs() {
        HashSet<ACL> configuredACLs = new HashSet<ACL>();
        for (ACLDefinition definition : this.definitions.values()) {
            Set<ACLEntry> entries = this.getEntries(definition, new ArrayList<String>());
            ACLImpl acl = new ACLImpl(definition.getResource(), entries);
            configuredACLs.add(acl);
        }
        return configuredACLs;
    }

    private Set<ACLEntry> getEntries(ACLDefinition definition, List<String> visitedACLs) {
        if (visitedACLs.contains(definition.getResource())) {
            throw new RuntimeException("Circular dependency between ACLs has been detected");
        }
        visitedACLs.add(definition.getResource());
        if (definition.getBaseResource() != null) {
            ACLDefinition superDefinition = this.definitions.get(definition.getBaseResource());
            if (superDefinition != null) {
                Set<ACLEntry> superEntries = this.getEntries(superDefinition, visitedACLs);
                Set<ACLEntry> entries = definition.getEntries();
                entries.addAll(superEntries);
                return entries;
            }
            throw new RuntimeException("Parent ACL not found: " + definition.getBaseResource());
        }
        return definition.getEntries();
    }
}

