/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.security.auth.login;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import org.jboss.security.auth.container.config.AuthModuleEntry;

//$Id: JASPIAuthenticationInfo.java 73520 2008-05-20 12:27:24Z anil.saldhana@jboss.com $

/**
 *  AuthenticationInfo based on JSR-196
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @since  Dec 21, 2005 
 */
@SuppressWarnings("unchecked")
public class JASPIAuthenticationInfo extends BaseAuthenticationInfo
{ 
   Map loginModuleStack = Collections.synchronizedMap(new HashMap()); 
   
   public JASPIAuthenticationInfo()
   {
      super(); 
   }
   
   public JASPIAuthenticationInfo(String name)
   {
      super(name); 
   }  
   
   public void add(LoginModuleStackHolder lmsHolder)
   {
      loginModuleStack.put(lmsHolder.getName(),lmsHolder );
   }
   
   public void add(AuthModuleEntry ame)
   {
      moduleEntries.add(ame);
   }
   
   public AuthModuleEntry[] getAuthModuleEntry()
   {
      AuthModuleEntry[] entries = new AuthModuleEntry[moduleEntries.size()];
      moduleEntries.toArray(entries);
      return entries;
   }
   
   public LoginModuleStackHolder getLoginModuleStackHolder(String name)
   {
      LoginModuleStackHolder info = (LoginModuleStackHolder) loginModuleStack.get(name);
      return info;
   } 
   
   public LoginModuleStackHolder[] getLoginModuleStackHolder()
   {
      ArrayList alist = new ArrayList(this.loginModuleStack.values());
      LoginModuleStackHolder[] lmshArr = new LoginModuleStackHolder[alist.size()];
      alist.toArray(lmshArr);
      return lmshArr;
   }
   
   
   public LoginModuleStackHolder removeLoginModuleStackHolder(String name)
   {
      LoginModuleStackHolder info = (LoginModuleStackHolder) loginModuleStack.remove(name);
      return info;
   } 
   
   public void copy(JASPIAuthenticationInfo pc)
   {
      loginModuleStack.putAll(pc.loginModuleStack);
      moduleEntries.addAll(pc.moduleEntries);
   }
   
   public String toString()
   {
      StringBuffer buffer = new StringBuffer("AuthModuleEntry[]:\n");
      for(int i = 0; i < moduleEntries.size(); i ++)
      {
         AuthModuleEntry entry = (AuthModuleEntry) moduleEntries.get(i);
         buffer.append("["+i+"]");
         buffer.append("\nAuthModule Class: "+entry.getAuthModuleName()); 
         buffer.append("\nOptions:");
         Map options = entry.getOptions();
         Iterator iter = options.entrySet().iterator();
         while( iter.hasNext() )
         {
            Entry e = (Entry) iter.next();
            buffer.append("name="+e.getKey());
            buffer.append(", value="+e.getValue());
            buffer.append("\n");
         }
      }
      return buffer.toString();
   }
}
