/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.security.auth.login;

import org.jboss.security.config.BaseSecurityInfo;

//$Id: BaseAuthenticationInfo.java 65938 2007-10-08 20:02:19Z anil.saldhana@jboss.com $

/**
 *  Base for AuthenticationInfo(JAAS) and JASPIAuthenticationInfo(JSR-196)
 *  @author <a href="mailto:anil.saldhana@jboss.org>Anil.Saldhana@jboss.org</a>
 *  @since  Dec 21, 2005 
 */
public class BaseAuthenticationInfo extends BaseSecurityInfo<Object>
{  
   public BaseAuthenticationInfo()
   {
      super();
   }
   
   public BaseAuthenticationInfo(String name)
   {
      super(name);
   }

   @Override
   protected BaseSecurityInfo<Object> create(String name)
   { 
      return new BaseAuthenticationInfo(name);
   }  
}
