/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.Principal;
import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.plugins.TransactionManagerLocator;

class DbUtil {
    DbUtil() {
    }

    /*
     * Loose catch block
     */
    static Group[] getRoleSets(String username, String dsJndiName, String rolesQuery, AbstractServerLoginModule aslm, boolean suspendResume) throws LoginException {
        HashMap<String, Group> setsMap;
        block62: {
            Exception e22222;
            Transaction tx;
            TransactionManager tm;
            ResultSet rs;
            Statement ps;
            Connection conn;
            boolean trace;
            Logger log;
            block58: {
                block53: {
                    Exception e22222;
                    Group[] groupArray;
                    block54: {
                        Group[] roleSets;
                        log = aslm.log;
                        trace = log.isTraceEnabled();
                        conn = null;
                        setsMap = new HashMap<String, Group>();
                        ps = null;
                        rs = null;
                        tm = null;
                        if (suspendResume) {
                            TransactionManagerLocator tml = new TransactionManagerLocator();
                            try {
                                tm = tml.getTM("java:/TransactionManager");
                            }
                            catch (NamingException e1) {
                                throw new RuntimeException(e1);
                            }
                            if (tm == null) {
                                throw new IllegalStateException("Transaction Manager is null");
                            }
                        }
                        tx = null;
                        if (suspendResume) {
                            try {
                                tx = tm.suspend();
                            }
                            catch (SystemException e3) {
                                throw new RuntimeException(e3);
                            }
                            if (trace) {
                                log.trace((Object)"suspendAnyTransaction");
                            }
                        }
                        InitialContext ctx = new InitialContext();
                        DataSource ds = (DataSource)ctx.lookup(dsJndiName);
                        conn = ds.getConnection();
                        if (trace) {
                            log.trace((Object)("Excuting query: " + rolesQuery + ", with username: " + username));
                        }
                        ps = conn.prepareStatement(rolesQuery);
                        try {
                            ps.setString(1, username);
                        }
                        catch (ArrayIndexOutOfBoundsException ignore) {
                            // empty catch block
                        }
                        rs = ps.executeQuery();
                        if (rs.next()) break block53;
                        if (trace) {
                            log.trace((Object)"No roles found");
                        }
                        if (aslm.getUnauthenticatedIdentity() == null) {
                            throw new FailedLoginException("No matching username found in Roles");
                        }
                        groupArray = roleSets = new Group[]{new SimpleGroup("Roles")};
                        Object var20_24 = null;
                        if (rs == null) break block54;
                        try {
                            rs.close();
                        }
                        catch (SQLException e22222) {
                            // empty catch block
                        }
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException e22222) {
                            // empty catch block
                        }
                    }
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    if (suspendResume) {
                        try {
                            tm.resume(tx);
                        }
                        catch (Exception e22222) {
                            throw new RuntimeException(e22222);
                        }
                        if (trace) {
                            log.trace((Object)"resumeAnyTransaction");
                        }
                    }
                    return groupArray;
                }
                do {
                    Group group;
                    String name = rs.getString(1);
                    String groupName = rs.getString(2);
                    if (groupName == null || groupName.length() == 0) {
                        groupName = "Roles";
                    }
                    if ((group = (Group)setsMap.get(groupName)) == null) {
                        group = new SimpleGroup(groupName);
                        setsMap.put(groupName, group);
                    }
                    try {
                        Principal p = aslm.createIdentity(name);
                        if (trace) {
                            log.trace((Object)("Assign user to role " + name));
                        }
                        group.addMember(p);
                    }
                    catch (Exception e4) {
                        log.debug((Object)("Failed to create principal: " + name), (Throwable)e4);
                    }
                } while (rs.next());
                Object var20_25 = null;
                if (rs == null) break block58;
                try {
                    rs.close();
                }
                catch (SQLException e22222) {
                    // empty catch block
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e22222) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (!suspendResume) break block62;
            try {
                tm.resume(tx);
            }
            catch (Exception e22222) {
                throw new RuntimeException(e22222);
            }
            if (trace) {
                log.trace((Object)"resumeAnyTransaction");
            }
            break block62;
            {
                LoginException le;
                catch (NamingException ex) {
                    le = new LoginException("Error looking up DataSource from: " + dsJndiName);
                    le.initCause(ex);
                    throw le;
                }
                catch (SQLException ex) {
                    le = new LoginException("Query failed");
                    le.initCause(ex);
                    throw le;
                }
            }
            catch (Throwable throwable) {
                Object var20_26 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e22222) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e22222) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (suspendResume) {
                    try {
                        tm.resume(tx);
                    }
                    catch (Exception e22222) {
                        throw new RuntimeException(e22222);
                    }
                    if (trace) {
                        log.trace((Object)"resumeAnyTransaction");
                    }
                }
                throw throwable;
            }
        }
        Group[] roleSets = new Group[setsMap.size()];
        setsMap.values().toArray(roleSets);
        return roleSets;
    }
}

